<?php
/* * *******************************************************************************
 * The content of this file is subject to the Delivery Notes 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

/**
 * Class ITS4YouOutgoingProducts_Field_Model
 */
class ITS4YouOutgoingProducts_Field_Model
{

    private $name;
    private $column;
    private $label;
    private $uitype;
    private $fieldInfo;

    /**
     * ITS4YouOutgoingProducts_Field_Model constructor.
     * @param $_name
     * @param $_column
     * @param $_label
     * @param $_uitype
     */
    public function __construct($_name, $_column, $_label, $_uitype)
    {
        $this->name = $_name;
        $this->column = $_column;
        $this->label = vtranslate($_label, 'ITS4YouOutgoingProducts');
        $this->uitype = $_uitype;
    }

    /**
     * Function to get the value of a given property
     * @param <String> $propertyName
     * @return <Object>
     * @throws Exception
     */
    public function get($propertyName)
    {
        if (property_exists($this, $propertyName)) {
            return $this->$propertyName;
        }
        return null;
    }

    /**
     * @return mixed
     */
    public function getFieldInfo()
    {
        $this->fieldInfo['mandatory'] = false;
        $this->fieldInfo['presence'] = true;
        $this->fieldInfo['quickcreate'] = false;
        $this->fieldInfo['masseditable'] = false;
        $this->fieldInfo['defaultvalue'] = false;
        $this->fieldInfo['name'] = $this->name;
        $this->fieldInfo['label'] = $this->label;
        $this->fieldInfo['type'] = $this->getFieldDataType();

        if (5 == $this->uitype) {
            $currentUser = Users_Record_Model::getCurrentUserModel();
            $this->fieldInfo['date-format'] = $currentUser->get('date_format');
        }

        return $this->fieldInfo;
    }

    /**
     * @return string
     */
    public function getFieldDataType()
    {
        if (10 == $this->uitype) {
            return 'reference';
        } elseif (5 == $this->uitype) {
            return 'date';
        } else {
            return 'string';
        }
    }

    /**
     * @return mixed
     */
    public function getCustomViewColumnName()
    {
        return $this->column;
    }

    /**
     * @return string
     */
    public function getListSearchTemplateName()
    {
        if (5 == $this->uitype) {
            return "uitypes/DateFieldSearchView.tpl";
        } else {
            return "uitypes/FieldSearchView.tpl";
        }
    }

    /**
     * @return int
     */
    public function getId()
    {
        return 0;
    }

    /**
     * @return string
     */
    public function getModuleName()
    {
        return $this->moduleName;
    }

    /**
     * @return bool
     */
    public function isEditable()
    {
        return false;
    }

    /**
     * @return $this
     */
    public function getUITypeModel()
    {
        return $this;
    }

    /**
     * @return mixed
     * @throws Exception
     */
    public function getName()
    {
        return $this->get('name');
    }

    /**
     * @return bool
     */
    public function isNameField()
    {
        return false;
    }
}
