<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouIssuecards_ReturnProducts_View extends Inventory_Edit_View
{
    /**
     * @param Vtiger_Request $request
     * @return array
     */
    public function getHeaderScripts(Vtiger_Request $request)
    {
        $jsFileNames = array(
            'modules.ITS4YouIssuecards.resources.ReturnProducts',
        );

        return array_merge(
            parent::getHeaderScripts($request),
            $this->checkAndConvertJsScripts($jsFileNames)
        );
    }

    public function process(Vtiger_Request $request)
    {
        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();
        $record = $request->get('record');
        $sourceRecord = $request->get('sourceRecord');
        $sourceModule = $request->get('sourceModule');

        $recordModel = Vtiger_Record_Model::getCleanInstance($moduleName);
        $lineItemQuantities = ITS4YouWarehouses_Products_Helper::getItemsQtyFromRequest($request);

        $parentRecordModel = Inventory_Record_Model::getInstanceById($sourceRecord);
        $currencyInfo = $parentRecordModel->getCurrencyInfo();
        $taxes = $parentRecordModel->getProductTaxes();
        $shippingTaxes = $parentRecordModel->getShippingTaxes();
        $relatedProducts = ITS4YouWarehouses_Products_Helper::getReturnProducts($parentRecordModel, $lineItemQuantities);
        $recordModel->setRecordFieldValues($parentRecordModel);
        $recordModel->set('issuecard_carrier', $parentRecordModel->get('receiptcard_carrier'));
        $recordModel->set('issue_date', (new DateTimeField(null))->getDBInsertDateValue());
        $recordModel->set('issuecardtype', 'Products return');
        $viewer->assign('PARENT_ID', $parentRecordModel->getId());
        $moduleModel = $recordModel->getModule();
        $fieldList = $moduleModel->getFields();
        $requestFieldList = array_intersect_key($request->getAll(), $fieldList);

        //get the inventory terms and conditions
        $inventoryRecordModel = Inventory_Record_Model::getCleanInstance($moduleName);
        $termsAndConditions = $inventoryRecordModel->getInventoryTermsandConditions();

        foreach ($requestFieldList as $fieldName => $fieldValue) {
            $fieldModel = $fieldList[$fieldName];
            if ($fieldModel->isEditable()) {
                $recordModel->set($fieldName, $fieldModel->getDBInsertValue($fieldValue));
            }
        }
        $recordStructureInstance = Vtiger_RecordStructure_Model::getInstanceFromRecordModel($recordModel, Vtiger_RecordStructure_Model::RECORD_STRUCTURE_MODE_EDIT);

        $viewer->assign('VIEW_MODE', "fullForm");

        $isRelationOperation = $request->get('relationOperation');

        //if it is relation edit
        $viewer->assign('IS_RELATION_OPERATION', $isRelationOperation);
        if ($isRelationOperation) {
            $viewer->assign('SOURCE_MODULE', $sourceModule);
            $viewer->assign('SOURCE_RECORD', $sourceRecord);
        }
        if (!empty($record) && $request->get('isDuplicate') == true) {
            $viewer->assign('IS_DUPLICATE', true);
        } else {
            $viewer->assign('IS_DUPLICATE', false);
        }
        $currencies = Inventory_Module_Model::getAllCurrencies();
        $picklistDependencyDatasource = Vtiger_DependencyPicklist::getPicklistDependencyDatasource($moduleName);

        $viewer->assign('PICKIST_DEPENDENCY_DATASOURCE', Zend_Json::encode($picklistDependencyDatasource));
        $viewer->assign('RECORD', $recordModel);
        $viewer->assign('RECORD_STRUCTURE_MODEL', $recordStructureInstance);
        $viewer->assign('RECORD_STRUCTURE', $recordStructureInstance->getStructure());
        $viewer->assign('MODULE', $moduleName);
        $viewer->assign('CURRENTDATE', date('Y-n-j'));
        $viewer->assign('USER_MODEL', Users_Record_Model::getCurrentUserModel());

        $viewer->assign('RELATED_PRODUCTS', $relatedProducts);
        $viewer->assign('SHIPPING_TAXES', $shippingTaxes);
        $viewer->assign('TAXES', $taxes);
        $viewer->assign('CURRENCINFO', $currencyInfo);
        $viewer->assign('CURRENCIES', $currencies);
        $viewer->assign('TERMSANDCONDITIONS', $termsAndConditions);

        $viewer->assign('PRODUCT_ACTIVE', false);
        $viewer->assign('SERVICE_ACTIVE', false);

        $viewer->view('EditView.tpl', $moduleName);
    }

}
