<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouIssuecards_ProductsPopupAjax_View extends ITS4YouIssuecards_ProductsPopup_View
{

    public function __construct()
    {
        parent::__construct();
        $this->exposeMethod('getListViewCount');
        $this->exposeMethod('getRecordsCount');
        $this->exposeMethod('getPageCount');
    }

    /**
     * Function returns module name for which Popup will be initialized
     * @param type $request
     */
    public function getModule($request)
    {
        return 'Products';
    }

    public function preProcess(Vtiger_Request $request)
    {
        return true;
    }

    public function postProcess(Vtiger_Request $request)
    {
        return true;
    }

    public function process(Vtiger_Request $request)
    {
        $mode = $request->get('mode');
        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
            return;
        }
        $viewer = $this->getViewer($request);

        $this->initializeListViewContents($request, $viewer);
        $moduleName = 'Inventory';
        $viewer->assign('MODULE_NAME', $moduleName);
        echo $viewer->view('PopupContents.tpl', $moduleName, true);
    }

}
