<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouIssuecards_ListView_Model extends Inventory_ListView_Model
{

    /**
     * Function to get the list of listview links for the module
     * @param <Array> $linkParams
     * @return <Array> - Associate array of Link Type to List of Vtiger_Link_Model instances
     */
    public function getListViewLinks($linkParams)
    {
        $links = parent::getListViewLinks($linkParams);

        $advancedLinks[] = array(
            'linktype' => 'LISTVIEW',
            'linklabel' => 'LBL_CREATE_DN',
            'linkurl' => 'javascript:ITS4YouIssuecards_List_Js.createDN();',
            'linkicon' => ''
        );
        foreach ($advancedLinks as $advancedLink) {
            $links['LISTVIEW'][] = Vtiger_Link_Model::getInstanceFromValues($advancedLink);
        }
        return $links;
    }

    /**
     * @param bool|array $linkParams
     * @return array
     * @throws Exception
     */
    public function getListViewMassActions($linkParams)
    {
        if (!method_exists('ITS4YouWarehouses_Module_Model', 'getListViewMassActions')) {
            return [];
        }

        return ITS4YouWarehouses_Module_Model::getListViewMassActions($linkParams, $this->getModule());
    }
}
