<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouIssuecards_CreateDN_Action extends Vtiger_Mass_Action
{

    public function checkPermission(Vtiger_Request $request)
    {
        return true;
    }

    public function preProcess(Vtiger_Request $request, $display = true)
    {
        return true;
    }

    public function postProcess(Vtiger_Request $request)
    {
        return true;
    }

    public function process(Vtiger_Request $request)
    {
        if ($request->get("mode") == "validate") {
            $this->validateIssuecards($request);
        }
    }

    public function validateIssuecards(Vtiger_Request $request)
    {
        $moduleName = $request->getModule();
        $response = new Vtiger_Response();

        $recordIds = $this->getRecordsListFromRequest($request);
        foreach ($recordIds as $recordId) {
            $recordModel = Vtiger_Record_Model::getInstanceById($recordId);
            if ($recordModel->get("parent_id") > 0) {
                $response->setError(500, vtranslate("ALERT_DN_ALREADY_CREATED", $moduleName));
                $response->emit();
                return;
            }
        }

        $response->setResult(array("recordIds" => $recordIds));
        $response->emit();
    }

}
