<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

require_once 'data/CRMEntity.php';

class ITS4YouIssuecards extends CRMEntity
{

    public $log, $db, $column_fields;
    public $table_name = 'its4you_issuecards';
    public $table_index = 'issuecardid';
    public $moduleName = 'ITS4YouIssuecards';
    public $parentName = 'Inventory';

    /**
     * Mandatory table for supporting custom fields.
     */
    public $customFieldTable = Array('its4you_issuecardscf', 'issuecardid');

    /**
     * Mandatory for Saving, Include tables related to this module.
     */
    public $tab_name = Array('vtiger_crmentity', 'its4you_issuecards', 'its4you_issuecardscf', 'vtiger_inventoryproductrel');

    /**
     * Mandatory for Saving, Include tablename and tablekey columnname here.
     */
    public $tab_name_index = Array(
        'vtiger_crmentity' => 'crmid',
        'its4you_issuecards' => 'issuecardid',
        'its4you_issuecardscf' => 'issuecardid',
        'vtiger_inventoryproductrel' => 'id'
    );

    /**
     * Mandatory for Listing (Related listview)
     */
    public $list_fields = Array(
        'Issuecards No' => Array('issuecards', 'issuecards_no'),
        'Related To' => Array('issuecards', 'parent_id'),
        'Description' => Array('crmentity', 'description'),
        'Issuecard Date' => Array('issuecards', 'issue_date'),
        'Status' => Array('issuecards', 'issuecardstatus'),
        'Assigned To' => Array('crmentity', 'smownerid')
    );
    public $list_fields_name = Array(
        'Issuecards No' => 'issuecards_no',
        'Related To' => 'parent_id',
        'Description' => 'description',
        'Issuecard Date' => 'issue_date',
        'Status' => 'issuecardstatus',
        'Assigned To' => 'assigned_user_id'
    );
    public $list_link_field = 'issuecards_no';
    public $search_fields = Array(
        'Issuecards No' => Array('issuecards', 'issuecards_no')
    );
    public $search_fields_name = Array(
        'Issuecards No' => 'issuecards_no'
    );
    public $popup_fields = Array('issuecards_no', 'startdate');
    public $def_basicsearch_col = 'issuecards_no';
    public $def_detailview_recname = 'issuecards_no';
    public $default_order_by = 'issuecards_no';
    public $default_sort_order = 'ASC';
    public $isLineItemUpdate = true;

    public $mandatory_fields = Array('createdtime', 'modifiedtime', 'issuecards_no');

    public $additional_column_fields = Array('assigned_user_name', 'smownerid', 'currency_id');

    public function __construct()
    {
        global $log;
        $this->column_fields = getColumnFields('ITS4YouIssuecards');
        $this->db = PearDatabase::getInstance();
        $this->log = $log;
    }

    public function insertIntoEntityTable($table_name, $module, $fileid = '')
    {
        //Ignore relation table insertions while saving of the record
        if ($table_name == 'vtiger_inventoryproductrel') {
            return;
        }
        parent::insertIntoEntityTable($table_name, $module, $fileid);
    }

    public function save_module($module)
    {
        //in ajax save we should not call this function, because this will delete all the existing product values
        if (isset($_REQUEST['totalProductCount'])) {
            if ($_REQUEST['action'] != 'ITS4YouIssuecardsAjax' && $_REQUEST['ajxaction'] != 'DETAILVIEW' && $_REQUEST['action'] != 'MassEditSave' && $_REQUEST['action'] != 'ProcessDuplicates' && $this->isLineItemUpdate != false) {
                //Based on the total Number of rows we will save the product relationship with this entity
                ITS4YouWarehouses_InventoryUtils_Helper::saveParentInventoryProducts($this);
            }
        }

        //Update status and parent_id - DN, manually because of display type
        $this->updateItemDetails();

        // create relationship between IC and related modules PO, SO, DN, INV
        $this->createRelationFromField('parent_id');
    }

    /**
     * @param string $name
     */
    public function createRelationFromField($name)
    {
        $module = Vtiger_Module_Model::getInstance($this->moduleName);
        $recordId = intval($this->column_fields[$name]);

        if (!empty($recordId)) {
            $parentModuleName = getSalesEntityType($recordId);
            $parentModule = Vtiger_Module_Model::getInstance($parentModuleName);

            if ($parentModule) {
                $relationModel = Vtiger_Relation_Model::getInstance($parentModule, $module);
                $relationModel->addRelation($recordId, $this->id);
            }
        }
    }

    public function updateItemDetails()
    {
        $data = $this->column_fields;
        $params = array(
            'currency_id' => $data['currency_id'],
            'conversion_rate' => $data['conversion_rate'],
        );

        if (!empty($data['issuecardstatus'])) {
            $params['issuecardstatus'] = $data['issuecardstatus'];
        }

        if (!empty($data['parent_id'])) {
            $params['parent_id'] = $data['parent_id'];
        }

        $query = sprintf('UPDATE its4you_issuecards SET %s=? WHERE issuecardid=?', implode('=?,', array_keys($params)));
        $this->db->pquery($query, [$params, $this->id]);
    }

    public function restore($module, $id)
    {
        global $current_user;

        $this->db->println("TRANS restore starts $module");
        $this->db->startTransaction();

        $this->db->pquery('UPDATE vtiger_crmentity SET deleted=0 WHERE crmid = ?', array($id));
        //Restore related entities/records
        $this->restoreRelatedRecords($module, $id);

        $product_info = $this->db->pquery("SELECT productid, quantity, sequence_no, incrementondel from vtiger_inventoryproductrel WHERE id=?", array($id));
        $numrows = $this->db->num_rows($product_info);
        for ($index = 0; $index < $numrows; $index++) {
            $productid = $this->db->query_result($product_info, $index, 'productid');
            $qty = $this->db->query_result($product_info, $index, 'quantity');

            deductFromProductStock($productid, $qty);
        }

        $this->db->completeTransaction();
        $this->db->println("TRANS restore ends");
    }

    /**
     * Invoked when special actions are performed on the module.
     * @param String Module name
     * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
     */
    public function vtlib_handler($modulename, $event_type)
    {
        require_once 'vtlib/Vtiger/Module.php';
        require_once 'modules/ModTracker/ModTracker.php';
        require_once 'modules/ModComments/ModComments.php';

        switch ($event_type) {
            case 'module.enabled':
            case 'module.postupdate':
            case 'module.postinstall':
                $this->addCustomLinks();
                break;
            case 'module.preupdate':
            case 'module.preuninstall':
            case 'module.disabled':
                $this->deleteCustomLinks();
                break;
        }
    }

    public function updateNumbering()
    {
        $this->setModuleSeqNumber('configure', $this->moduleName, 'IC', 1);
        $this->updateMissingSeqNumber($this->moduleName);
    }

    public function addCustomLinks()
    {
        $this->updateNumbering();
        $this->updateRelatedList();
        $this->updateReferenceList();

        Settings_MenuEditor_Module_Model::addModuleToApp($this->moduleName, $this->parentName);
        ModTracker::enableTrackingForModule(getTabid($this->moduleName));
        ModComments::addWidgetTo([$this->moduleName]);
    }

    public function updateReferenceList()
    {
        $module = Vtiger_Module_Model::getInstance($this->moduleName);
        $field = $module ? $module->getField('parent_id') : false;

        if ($field) {
            $field->setRelatedModules([
                'ITS4YouReceiptcards',
                'ITS4YouWHDeliveryNotes',
            ]);
        }
    }

    /**
     * @var array
     * [module, related module, relate label, related actions, related function]
     * $moduleInstance->setRelatedList($relatedListModule, $relatedLabel, $relatedActions, $relatedFunction);
     */
    public $registerRelatedLists = [
        ['Products', 'ITS4YouIssuecards'],
        ['ITS4YouWHDeliveryNotes', 'ITS4YouIssuecards'],
        ['ITS4YouIssuecards', 'ITS4YouWHDeliveryNotes'],
        ['ITS4YouReceiptcards', 'ITS4YouIssuecards'],
        ['ITS4YouIssuecards', 'ITS4YouReceiptcards'],
        ['ITS4YouWarehouses', 'ITS4YouIssuecards', 'ITS4YouIssuecards', '', 'get_issuecards'],
        ['ITS4YouIssuecards', 'Documents', 'Documents', 'add,select', 'get_attachments'],
    ];

    /**
     * @param bool $register
     */
    public function updateRelatedList($register = true) {

        foreach ($this->registerRelatedLists as $relatedList) {
            $module = Vtiger_Module::getInstance($relatedList[0]);
            $relatedModule = Vtiger_Module::getInstance($relatedList[1]);

            if($module && $relatedModule) {
                $relatedLabel = isset($relatedList[2]) ? $relatedList[2] : $relatedModule->name;
                $relatedActions = isset($relatedList[3]) ? $relatedList[3] : '';
                $relatedFunction = isset($relatedList[4]) ? $relatedList[4] : 'get_related_list';

                if($register) {
                    if ($this->checkRelatedList($module->getId(), $relatedModule->getId(), $relatedLabel, $relatedFunction) == 0) {
                        $module->setRelatedList($relatedModule, $relatedLabel, $relatedActions, $relatedFunction);
                    }
                } else {
                    $module->unsetRelatedList($relatedModule, $relatedLabel, $relatedFunction);
                }
            }
        }
    }

    /**
     * @param int $tabid
     * @param int $related_tabid
     * @param string $label
     * @param string $name
     * @return mixed
     */
    private function checkRelatedList($tabid, $related_tabid, $label, $name = "get_related_list")
    {
        $query = "SELECT relation_id FROM vtiger_relatedlists WHERE tabid=? AND related_tabid=? AND label=? AND name=?";
        $result = $this->db->pquery($query, Array($tabid, $related_tabid, $label, $name));
        return $this->db->num_rows($result);
    }

    public function deleteCustomLinks()
    {
        $this->updateRelatedList(false);

        ModTracker::disableTrackingForModule(getTabid($this->moduleName));
        ModComments::removeWidgetFrom([$this->moduleName]);
    }

    /**
     * @param string $module
     * @param object $queryPlanner
     * @return string
     * @throws Exception
     */
    public function generateReportsQuery($module, $queryPlanner)
    {
        $query = parent::generateReportsQuery($module, $queryPlanner);

        // Define the dependency matrix ahead
        $matrix = $queryPlanner->newDependencyMatrix();
        $matrix->setDependency('vtiger_crmentity' . $this->moduleName, array('vtiger_users' . $this->moduleName, 'vtiger_groups' . $this->moduleName, 'vtiger_lastModifiedBy' . $this->moduleName));
        $matrix->setDependency('vtiger_inventoryproductrel' . $this->moduleName, array('vtiger_products' . $this->moduleName, 'vtiger_service' . $this->moduleName));


        $requiredTables = [
            'vtiger_inventoryproductrel' => 'id',
        ];

        $this->generateCustomReportsQuery($this->table_index, $this->table_name, $requiredTables, $queryPlanner, $query, 'tmp');

        $tableName = 'vtiger_inventoryproductreltmp' . $this->moduleName;
        $requiredTables = [
            'vtiger_products' => 'productid',
            'vtiger_service' => 'serviceid',
        ];

        $this->generateCustomReportsQuery('productid', $tableName, $requiredTables, $queryPlanner, $query, '');

        return $query;
    }

    /**
     * @param string $fieldName
     * @param string $tableName
     * @param array $requiredTables
     * @param object $queryPlanner
     * @param string $query
     * @param string $rel
     * @throws Exception
     */
    public function generateCustomReportsQuery($fieldName, $tableName, $requiredTables, &$queryPlanner, &$query, $rel = 'Rel')
    {
        $thisModule = $this->moduleName;
        $relFieldId = '';

        if ('Rel' === $rel) {
            $result = $this->db->pquery('SELECT fieldid FROM vtiger_field WHERE columnname = ? AND tablename = ?',
                array($fieldName, $tableName));
            $relFieldId = $this->db->query_result($result, 0, 'fieldid');
        }

        foreach ($requiredTables as $requiredTable => $requiredField) {
            $customRequiredTableName = $requiredTable . $rel . $thisModule . $relFieldId;

            if ($queryPlanner->requireTable($customRequiredTableName)) {
                $query .= sprintf(
                    ' LEFT JOIN %s AS %s ON %s.%s = %s.%s ',
                    $requiredTable,
                    $customRequiredTableName,
                    $customRequiredTableName,
                    $requiredField,
                    $tableName,
                    $fieldName
                );
            }
        }
    }
}
