<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouIncomingProducts_Module_Model extends Vtiger_Module_Model
{
    public static $mobileIcon = 'package';

    public function __construct()
    {
        parent::__construct();

        $headerFieldModels["productname"] = new ITS4YouIncomingProducts_Field_Model("productname", "productname", "HEAD_PRODUCT", 2);
        $headerFieldModels["ordered_qty"] = new ITS4YouIncomingProducts_Field_Model("ordered_qty", "ordered_qty", "HEAD_OQTY", 7);
        $headerFieldModels["receipted_qty"] = new ITS4YouIncomingProducts_Field_Model("receipted_qty", "receipted_qty", "HEAD_RQTY", 0);
        $headerFieldModels["receipt_doc"] = new ITS4YouIncomingProducts_Field_Model("receipt_doc", "receipt_doc", "HEAD_PORDERNO", 10);
        $headerFieldModels["duedate"] = new ITS4YouIncomingProducts_Field_Model("duedate", "duedate", "HEAD_DUEDATE", 5);
        $headerFieldModels["status"] = new ITS4YouIncomingProducts_Field_Model("status", "status", "HEAD_STATUS", 15);
        $headerFieldModels["vendorname"] = new ITS4YouIncomingProducts_Field_Model("vendorname", "vendorname", "HEAD_VENDOR", 81);
        $headerFieldModels["assigned_user_id"] = new ITS4YouIncomingProducts_Field_Model("assigned_user_id", "smownerid", "HEAD_ASSIGNED_TO", 53);

        $this->fields = $headerFieldModels;
    }

    public function getField($fieldName)
    {
        return $this->fields[$fieldName];
    }

    /**
     * Special overriden implementation for profile generation purposes!
     * If value of parameter $blockInstance == false then empty array is returned,
     * otherwise $this->fields are returned.
     * @param type $blockInstance
     * @return type
     */
    public function getFields($blockInstance = false)
    {
        if ($blockInstance !== false) {
            return $this->fields;
        } else {
            return array();
        }
    }

    /**
     * Function to get the list of listview links for the module
     * @return <Array> - Associate array of Link Type to List of Vtiger_Link_Model instances
     */
    public function getListViewLinks()
    {
        return array();
    }

    /**
     * Function to get the Quick Links for the module
     * @param <Array> $linkParams
     * @return <Array> List of Vtiger_Link_Model instances
     */
    public function getSideBarLinks($linkParams)
    {
        $linkTypes = array('SIDEBARLINK', 'SIDEBARWIDGET');
        $links = Vtiger_Link_Model::getAllByType($this->getId(), $linkTypes, $linkParams);

        $quickLinks = array(
            array(
                'linktype' => 'SIDEBARLINK',
                'linklabel' => 'LBL_RECORDS_LIST',
                'linkurl' => $this->getDefaultUrl(),
                'linkicon' => '',
            ),
        );
        foreach ($quickLinks as $quickLink) {
            $links['SIDEBARLINK'][] = Vtiger_Link_Model::getInstanceFromValues($quickLink);
        }
        return $links;
    }

    /**
     * Function to get the url for list view of the module
     * @return <string> - url
     */
    public function getDefaultUrl()
    {
        return 'index.php?module=' . $this->get('name') . '&view=' . $this->getListViewName();
    }

    /**
     * Function to get the list of Mass actions for the module
     * @param <Array> $linkParams
     * @return <Array> - Associative array of Link type to List of  Vtiger_Link_Model instances for Mass Actions
     */
    public function getListViewMassActions()
    {
        return array();
    }

    public function getSettingLinks()
    {
        $settingsLinks = array();
        $currentUserModel = Users_Record_Model::getCurrentUserModel();

        if ($currentUserModel->isAdminUser()) {
            $settingsLinks[] = array(
                'linktype' => 'LISTVIEWSETTING',
                'linklabel' => 'LBL_MODULE_REQUIREMENTS',
                'linkurl' => 'index.php?module=ITS4YouInstaller&parent=Settings&view=Requirements&mode=Module&sourceModule=ITS4YouIncomingProducts',
            );
            $settingsLinks[] = array(
                'linktype' => 'LISTVIEWSETTING',
                'linklabel' => 'LBL_LICENSE',
                'linkurl' => 'index.php?module=ITS4YouInstaller&view=License&parent=Settings&sourceModule=ITS4YouIncomingProducts',
            );
            $settingsLinks[] = array(
                'linktype' => 'LISTVIEWSETTING',
                'linklabel' => 'LBL_UPGRADE',
                'linkurl' => 'index.php?module=ModuleManager&parent=Settings&view=ModuleImport&mode=importUserModuleStep1',
            );
            $settingsLinks[] = array(
                'linktype' => 'LISTVIEWSETTING',
                'linklabel' => 'LBL_UNINSTALL',
                'linkurl' => 'index.php?module=ITS4YouInstaller&view=Uninstall&parent=Settings&sourceModule=ITS4YouIncomingProducts',
            );
        }

        return $settingsLinks;
    }

    /**
     * @return bool
     */
    public function isStarredEnabled()
    {
        return false;
    }

    /**
     * @return bool
     */
    public function isFilterColumnEnabled() {
        return false;
    }

    public function getDatabaseTables()
    {
        return [];
    }

    public function getPicklistFields()
    {
        return [];
    }
}
