<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouIncomingProducts_ListView_Model extends Vtiger_ListView_Model
{

    private $moduleModel;
    private $purchaseOrderLineItems;

    public function __construct()
    {
        $this->moduleModel = Vtiger_Module_Model::getInstance("ITS4YouIncomingProducts");
    }

    /**
     * Function to get the list view header
     * @return <Array> - List of Vtiger_Field_Model instances
     */
    public function getListViewHeaders()
    {
        return $this->moduleModel->getFields("DEFAULT_BLOCK");
    }

    /**
     * Function to get the list view entries
     * @param Vtiger_Paging_Model $pagingModel
     * @return <Array> - Associative array of record id mapped to Vtiger_Record_Model instance.
     */
    public function getListViewEntries($pagingModel)
    {
        $db = PearDatabase::getInstance();

        $moduleName = $this->moduleModel->get('name');
        $moduleModel = Vtiger_Module_Model::getInstance($moduleName);

        $searchParams = $this->get('search_params');
        if (empty($searchParams)) {
            $searchParams = array();
        }

        list($searchQuery, $params) = $this->getSearchQuery($searchParams);

        $listQuery = $this->getQuery() . $searchQuery;

        $orderBy = $this->getForSql('orderby');
        $sortOrder = $this->getForSql('sortorder');

        $startIndex = $pagingModel->getStartIndex();
        $pageLimit = $pagingModel->getPageLimit();

        if (!empty($orderBy)) {
            $listQuery .= ' ORDER BY ' . $orderBy . ' ' . $sortOrder;
        }
        $listQuery .= " LIMIT $startIndex," . ($pageLimit + 1);

        $listResult = $db->pquery($listQuery, $params);
        $listViewRecordModels = array();
        $listViewEntries = $this->getListViewRecords($listResult);

        $pagingModel->calculatePageRange($listViewEntries);

        if ($db->num_rows($listResult) > $pageLimit) {
            array_pop($listViewEntries);
            $pagingModel->set('nextPageExists', true);
        } else {
            $pagingModel->set('nextPageExists', false);
        }

        $index = 0;
        foreach ($listViewEntries as $recordId => $record) {
            $rawData = $db->query_result_rowdata($listResult, $index++);
            $record['id'] = $recordId;
            $listViewRecordModels[$recordId] = $moduleModel->getRecordFromArray($record, $rawData);
        }
        return $listViewRecordModels;
    }

    private function getSearchQuery($searchParams)
    {
        $searchQuery = "";
        $params = array();
        if (isset($searchParams[0]["columns"])) {
            $subSearchParams = $searchParams[0]["columns"];
            foreach ($subSearchParams as $searchParamsArr) {

                switch ($searchParamsArr["columnname"]) {
                    case "duedate":
                        $searchQuery .= " (vtiger_purchaseorder.duedate BETWEEN ? AND ? OR its4you_receiptcards.adoption_date BETWEEN ? AND ?)";
                        list($date_start, $date_end) = explode(",", $searchParamsArr["value"]);
                        $date_start = DateTimeField::convertToDBFormat($date_start);
                        $date_end = DateTimeField::convertToDBFormat($date_end);
                        $params = array_merge($params, array($date_start, $date_end, $date_start, $date_end));
                        break;

                    case "receipt_doc":
                        $searchQuery .= " (vtiger_purchaseorder.purchaseorder_no LIKE ? OR its4you_receiptcards.receiptcards_no LIKE ?)";
                        $params = array_merge($params, array("%" . $searchParamsArr["value"] . "%", "%" . $searchParamsArr["value"] . "%"));
                        break;

                    case "status":
                        $searchQuery .= " (vtiger_purchaseorder.postatus LIKE ? OR its4you_receiptcards.receiptcardstatus LIKE ?)";
                        $params = array_merge($params, array("%" . $searchParamsArr["value"] . "%", "%" . $searchParamsArr["value"] . "%"));
                        break;

                    case "vendorname":
                        $searchQuery .= " (vtiger_vendor.vendorname LIKE ? OR ven2.vendorname LIKE ?)";
                        $params = array_merge($params, array("%" . $searchParamsArr["value"] . "%", "%" . $searchParamsArr["value"] . "%"));
                        break;

                    case "ordered_qty":
                        $searchParamsArr["column_condition"] = '';
                        $searchQuery .= " vtiger_inventoryproductrel.quantity = ?";
                        $params = array_merge($params, array($searchParamsArr["value"]));
                        break;

                    case "receipted_qty":
                        break;

                    case "smownerid":
                        $searchQuery .= " (vtiger_groups.groupname LIKE ? OR vtiger_users.first_name LIKE ? OR vtiger_users.last_name LIKE ?)";
                        $params = array_merge($params, array("%" . $searchParamsArr["value"] . "%", "%" . $searchParamsArr["value"] . "%", "%" . $searchParamsArr["value"] . "%"));
                        break;


                    default:
                        $searchQuery .= $searchParamsArr["columnname"] . " LIKE ? ";
                        array_push($params, "%" . $searchParamsArr["value"] . "%");
                        break;
                }

                if(isset($searchParamsArr["column_condition"])) {
                    $searchQuery .= ' ' . $searchParamsArr["column_condition"] . ' ';
                }
            }
        }
        if (!empty(trim($searchQuery))) {
            $searchQuery = " AND " . $searchQuery;
        }

        return array($searchQuery, $params);
    }

    /**
     * @return string
     * @throws Exception
     */
    public function getQuery()
    {
        $db = PearDatabase::getInstance();
//        $db->setDebug(true);
        $filterLineItemIDs = array();
        //In project MultiWarehouses4You RC are not taken into consideration when it comes to Incoming products
        //RC line item IDs
//        $sql = "SELECT vtiger_inventoryproductrel.lineitem_id
//                FROM its4you_receiptcards
//                INNER JOIN vtiger_crmentity
//                    ON vtiger_crmentity.crmid = its4you_receiptcards.receiptcardid
//                INNER JOIN vtiger_inventoryproductrel
//                    ON its4you_receiptcards.receiptcardid=vtiger_inventoryproductrel.id
//                WHERE vtiger_crmentity.deleted = 0
//                  AND its4you_receiptcards.receiptcardstatus NOT IN ('Delivered', 'Canceled')";
//        $result = $db->pquery($sql, array());
//        while ($row = $db->fetchByAssoc($result)) {
//            $filterLineItemIDs[] = $row["lineitem_id"];
//        }
        //PO line item IDs
        $sql = "SELECT vtiger_purchaseorder.purchaseorderid
                FROM vtiger_purchaseorder
                INNER JOIN vtiger_crmentity
                    ON vtiger_crmentity.crmid = vtiger_purchaseorder.purchaseorderid
                WHERE vtiger_crmentity.deleted = 0
                  AND vtiger_purchaseorder.postatus NOT IN ('Cancelled')";
        $result = $db->pquery($sql, array());
        $this->purchaseOrderLineItems = array();
        $filterQuery = "";
        /* @var $actionBlock ITS4YouWarehouses_PO_ActionBlock */
        while ($row = $db->fetchByAssoc($result)) {
            $actionBlock = ITS4YouWarehouses_Base_ActionBlock::factory("PurchaseOrder", $row["purchaseorderid"]);
            $tmpLineItems = $actionBlock->getToBeReceiptedLineItems();
            $this->purchaseOrderLineItems = (array)$this->purchaseOrderLineItems + (array)$tmpLineItems;
            $filterLineItemIDs = array_merge($filterLineItemIDs, array_keys($tmpLineItems));
        }

        if (count($filterLineItemIDs) > 0) {
            $filterQuery = " AND vtiger_inventoryproductrel.lineitem_id IN (" . implode(",", $filterLineItemIDs) . ") ";
        } else {
            $filterQuery = " AND 1=0 "; //if no line item meets the condition above then no record should be found
        }

        $query = "SELECT                  
                 vtiger_products.productname,
                 'Products' AS entitytype,
                 vtiger_inventoryproductrel.lineitem_id AS uniqueid,
                 vtiger_inventoryproductrel.productid,
                 vtiger_inventoryproductrel.sequence_no,
                 vtiger_inventoryproductrel.quantity AS ordered_qty,                 
                 vtiger_inventoryproductrel.quantity AS toreceipt_qty,
                 vtiger_inventoryproductrel.id,
                 vtiger_inventoryproductrel.id AS entityid,
                 vtiger_crmentity.setype,
                 vtiger_crmentity.smownerid,
                 vtiger_purchaseorder.purchaseorderid,
                 CASE WHEN vtiger_purchaseorder.purchaseorderid != '' THEN vtiger_purchaseorder.purchaseorder_no ELSE its4you_receiptcards.receiptcards_no END AS receipt_doc, 
                 CASE WHEN vtiger_purchaseorder.purchaseorderid != '' THEN vtiger_purchaseorder.duedate ELSE its4you_receiptcards.adoption_date END AS duedate, 
                 CASE WHEN vtiger_purchaseorder.purchaseorderid != '' THEN vtiger_purchaseorder.postatus ELSE its4you_receiptcards.receiptcardstatus END AS status,                 
                 CASE WHEN vtiger_purchaseorder.purchaseorderid != '' THEN vtiger_purchaseorder.subject ELSE po2.subject END AS subject,                 
                 CASE WHEN vtiger_purchaseorder.purchaseorderid != '' THEN vtiger_vendor.vendorname ELSE ven2.vendorname END AS vendorname,
                 CASE WHEN vtiger_purchaseorder.purchaseorderid != '' THEN vtiger_vendor.vendorid ELSE ven2.vendorid END AS vendorid,
                 CASE WHEN vtiger_users.user_name != '' THEN CONCAT_WS(' ', vtiger_users.first_name, vtiger_users.last_name) ELSE vtiger_groups.groupname END AS assigned_user_id
          FROM vtiger_inventoryproductrel 
          LEFT JOIN vtiger_purchaseorder
                  ON vtiger_purchaseorder.purchaseorderid=vtiger_inventoryproductrel.id
          LEFT JOIN its4you_receiptcards
                  ON its4you_receiptcards.receiptcardid=vtiger_inventoryproductrel.id
          INNER JOIN vtiger_crmentity
                  ON vtiger_crmentity.crmid=vtiger_inventoryproductrel.id 
          LEFT JOIN vtiger_users 
                  ON vtiger_users.id = vtiger_crmentity.smownerid
          LEFT JOIN vtiger_groups 
                  ON vtiger_groups.groupid = vtiger_crmentity.smownerid          
          INNER JOIN vtiger_products 
                 ON vtiger_products.productid=vtiger_inventoryproductrel.productid           
          LEFT JOIN vtiger_vendor
                 ON vtiger_vendor.vendorid=vtiger_purchaseorder.vendorid 
          LEFT JOIN vtiger_purchaseorder AS po2
                 ON its4you_receiptcards.referenceid=po2.purchaseorderid
          LEFT JOIN vtiger_vendor AS ven2
                 ON its4you_receiptcards.vendorid=ven2.vendorid
          WHERE vtiger_crmentity.deleted=0             
            " . $this->getListViewSecurityParameterComplex(array("PurchaseOrder", "ITS4YouReceiptcards")) . " " . $filterQuery;
//                . $searchQuery . $filterQuery . "
//          ORDER BY vtiger_crmentity.setype DESC, duedate DESC, vtiger_inventoryproductrel.id, vtiger_inventoryproductrel.sequence_no
//          LIMIT " . $offset . "," . $list_max_entries_per_page;

        return $query;
    }

    //since this function can handle only one module at time then both modules (tabid1 and tabid2) must be public in order to have all records visible

    private function getListViewSecurityParameterComplex($modulesArray)
    {
        $sec_query = "";
        if (count($modulesArray) > 0) {
            $sec_query .= " AND (";
            foreach ($modulesArray as $module) {
                $sec_query .= $this->getListViewSecurityParameter($module) . " OR ";
            }
            $sec_query = rtrim($sec_query, " OR ") . ") ";
        }

        return $sec_query;
    }

    private function getListViewSecurityParameter($module)
    {
        global $current_user;
        require 'user_privileges/user_privileges_' . $current_user->id . '.php';
        require 'user_privileges/sharing_privileges_' . $current_user->id . '.php';

        $tabid = getTabid($module);
        $sec_query = " (vtiger_crmentity.setype = '" . $module . "'";
        if ($is_admin == false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 && $defaultOrgSharingPermission[$tabid] == 3) {
            $sec_query .= " AND 
                        (vtiger_crmentity.smownerid IN (" . $current_user->id . " )
                            OR vtiger_crmentity.smownerid IN
                             (
                                 SELECT vtiger_user2role.userid FROM vtiger_user2role
                                 INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid
                                 INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid
                                 WHERE vtiger_role.parentrole LIKE '" . $current_user_parent_role_seq . "::%'
                             )
                             OR vtiger_crmentity.smownerid IN
                             (
                                 SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per
                                 WHERE userid=" . $current_user->id . " AND tabid=" . $tabid . "
                             )
                             OR
                             (";

            // Build the query based on the group association of current user.
            if (sizeof($current_user_groups) > 0) {
                $sec_query .= " vtiger_groups.groupid IN (" . implode(",", $current_user_groups) . ") OR ";
            }
            $sec_query .= " vtiger_groups.groupid IN
						(
                                                    SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid
                                                    FROM vtiger_tmp_read_group_sharing_per
                                                    WHERE userid=" . $current_user->id . " and tabid=" . $tabid . "
						)";
            $sec_query .= ")
                    )";
        }
        $sec_query .= ")";

        return $sec_query;
    }

    private function getListViewRecords($_dbResult)
    {
        global $current_user;

        $db = PearDatabase::getInstance();
        $listViewEntries = array();
        while ($row = $db->fetchByAssoc($_dbResult)) {
            foreach ($row as $key => $val) {
                switch ($key) {
                    case "issue_date":
                        $tmpVal = DateTimeField::convertToUserFormat($val);
                        break;

                    default:
                        $tmpVal = $val;
                }

                $listViewEntries[$row["uniqueid"]][$key] = $tmpVal;
            }

            // check partially received products of PO = products that already have been received    
            // get received data only when purchase order id is changed                 
            if (isset($this->purchaseOrderLineItems[$row["uniqueid"]])) {
                /* @var $lineItem ITS4YouWarehouses_InventoryLineItem_Helper */
                $lineItem = $this->purchaseOrderLineItems[$row["uniqueid"]];
                $listViewEntries[$row["uniqueid"]]["toreceipt_qty"] = $lineItem->getQuantity();
            }
            //add info already receipted qty
            $tmpDiff = $listViewEntries[$row["uniqueid"]]["ordered_qty"] - $listViewEntries[$row["uniqueid"]]["toreceipt_qty"];
            $listViewEntries[$row["uniqueid"]]["receipted_qty"] = ITS4YouWarehouses_Base_ActionBlock::formatNumberForDetailView($tmpDiff);
            //format numeric fields at the end
            $listViewEntries[$row["uniqueid"]]["toreceipt_qty"] = ITS4YouWarehouses_Base_ActionBlock::formatNumberForDetailView($listViewEntries[$row["uniqueid"]]["toreceipt_qty"]);
            $listViewEntries[$row["uniqueid"]]["ordered_qty"] = ITS4YouWarehouses_Base_ActionBlock::formatNumberForDetailView($listViewEntries[$row["uniqueid"]]["ordered_qty"]);
        }

        return $listViewEntries;
    }

    /**
     * Function to get the list view entries
     * @param Vtiger_Paging_Model $pagingModel
     * @return <Array> - Associative array of record id mapped to Vtiger_Record_Model instance.
     */
    public function getListViewCount()
    {
        $db = PearDatabase::getInstance();

        $searchParams = $this->get('search_params');
        if (empty($searchParams)) {
            $searchParams = array();
        }

        list($searchQuery, $params) = $this->getSearchQuery($searchParams);
        $listQuery = $this->getQuery() . $searchQuery;

        $position = stripos($listQuery, 'FROM');
        if ($position) {
            $split = explode('FROM', $listQuery);
            unset($split[0]);

            $listQuery = 'SELECT count(*) AS count FROM ' . implode('FROM', $split);
        }

        $listResult = $db->pquery($listQuery, $params);
        return $db->query_result($listResult, 0, 'count');
    }

    /**
     * Function to get the list of Mass actions for the module
     * @param <Array> $linkParams
     * @return <Array> - Associative array of Link type to List of  Vtiger_Link_Model instances for Mass Actions
     */
    public function getListViewMassActions($linkParams)
    {

        $links = array();

        $massActionLinks[] = array(
            'linktype' => 'LISTVIEWMASSACTION',
            'linklabel' => 'LBL_MASS_RECEIPT',
            'linkurl' => 'javascript:ITS4YouIncomingProducts_List_Js.massReceipt();',
            'linkicon' => ''
        );

        foreach ($massActionLinks as $massActionLink) {
            $links['LISTVIEWMASSACTION'][] = Vtiger_Link_Model::getInstanceFromValues($massActionLink);
        }

        return $links;
    }

    /**
     * @param $linkParams
     * @return bool
     */
    public function getSideBarLinks($linkParams) {
        return false;
    }
}
