<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouIncomingProducts_Field_Model
{
    /**
     * @var string
     */
    protected $moduleName = 'ITS4YouIncomingProducts';
    /**
     * @var
     */
    protected $label;
    /**
     * @var
     */
    protected $fieldInfo;
    /**
     * @var
     */
    private $name;
    /**
     * @var
     */
    private $column;
    /**
     * @var
     */
    private $uitype;

    /**
     * ITS4YouWarehouses_DummyListViewField_Model constructor.
     * @param $_name
     * @param $_column
     * @param $_label
     * @param $_uitype
     */
    public function __construct($_name, $_column, $_label, $_uitype)
    {
        $this->name = $_name;
        $this->column = $_column;
        $this->label = $_label;
        $this->uitype = $_uitype;
    }

    /**
     * @return array
     */
    public function getFieldInfo()
    {
        $this->fieldInfo['mandatory'] = false;
        $this->fieldInfo['presence'] = true;
        $this->fieldInfo['quickcreate'] = false;
        $this->fieldInfo['masseditable'] = false;
        $this->fieldInfo['defaultvalue'] = false;
        $this->fieldInfo['name'] = $this->name;
        $this->fieldInfo['type'] = $this->getFieldDataType();

        if (5 == $this->uitype) {
            $currentUser = Users_Record_Model::getCurrentUserModel();
            $this->fieldInfo['date-format'] = $currentUser->get('date_format');
        }

        $this->fieldInfo['label'] = vtranslate($this->label, "ITS4YouIncomingProducts");

        return $this->fieldInfo;
    }

    /**
     * @return bool
     */
    public function isNameField()
    {
        return false;
    }

    /**
     * Function which sets value for given name
     * @param string $name - name for which value need to be assinged
     * @param string $value - values that need to be assigned
     * @return self
     */
    public function set($name, $value)
    {
        $this->$name = $value;

        return $this;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return 0;
    }

    /**
     * @return string
     */
    public function getFieldDataType()
    {
        if (5 != $this->uitype) {
            return 'string';
        } else {
            return 'date';
        }
    }

    /**
     * @return mixed
     */
    public function getCustomViewColumnName()
    {
        return $this->column;
    }

    /**
     * @return string
     */
    public function getListSearchTemplateName()
    {
        if (empty($this->uitype)) {
            return 'uitypes/EmptyFieldSearchView.tpl';
        } elseif (5 !== (int)$this->uitype) {
            return 'uitypes/FieldSearchView.tpl';
        } else {
            return 'uitypes/DateFieldSearchView.tpl';
        }
    }

    /**
     * @return string
     */
    public function isSearchable()
    {
        return ($this->uitype > 0 ? 'true' : 'false');
    }

    /**
     * @return $this
     */
    public function getUITypeModel()
    {
        return $this;
    }

    /**
     * @return mixed
     * @throws Exception
     */
    public function getName()
    {
        return $this->get('name');
    }

    /**
     * Function to get the value of a given property
     * @param string $propertyName
     * @return object
     * @throws Exception
     */
    public function get($propertyName)
    {
        if (property_exists($this, $propertyName)) {
            return $this->$propertyName;
        }
        return null;
    }

    /**
     * @return string
     */
    public function getModuleName()
    {
        return $this->moduleName;
    }

    /**
     * @return bool
     */
    public function isEditable()
    {
        return false;
    }
}
