<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouImport_XLSWriter_Writer extends ITS4YouImport_PHPExcelWriter_Writer
{

    protected function __construct($fileName)
    {
        parent::__construct($fileName);
    }

    protected function getExportContentType()
    {
        return "application/vnd.ms-excel";
    }

    protected function getOutputFileName()
    {
        return $this->fileName . ".xls";
    }

    protected function closeOutput()
    {
        $writer = PHPExcel_IOFactory::createWriter($this->phpExcel, "Excel5");
        /* @var $writer PHPExcel_Writer_IWriter */
        $writer->save("php://output");
    }

}
