<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

abstract class ITS4YouImport_FileWriter_Writer
{

    protected $fileName;

    protected function __construct($fileName)
    {
        $this->fileName = $fileName;
    }

    /**
     * @param string $fileName
     * @param string $fileType
     * @return ITS4YouImport_CSVWriter_Writer|ITS4YouImport_XLSWriter_Writer|ITS4YouImport_XLSXWriter_Writer
     * @throws Exception
     */
    public static function factory($fileName, $fileType)
    {
        switch ($fileType) {
            case "vcf":
            case "csv":
                return new ITS4YouImport_CSVWriter_Writer($fileName);

            case "xls":
                return new ITS4YouImport_XLSWriter_Writer($fileName);

            case "xlsx":
                return new ITS4YouImport_XLSXWriter_Writer($fileName);

            //currently no specific writer is implemented => CSV is used instead
            default:
                throw new Exception("ITS4YouImport :: File writer for " . $fileType . "not supported");
        }
    }

    public function output($headers, $entries)
    {
        header("Content-Disposition:attachment;filename=" . $this->getOutputFileName());
        header("Content-Type:" . $this->getExportContentType() . ";charset=UTF-8");
        header("Expires: Mon, 31 Dec 2000 00:00:00 GMT");
        header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
        header("Cache-Control: post-check=0, pre-check=0", false);

        $this->outputHeader($headers);
        $this->outputData($entries);
        $this->closeOutput();
    }

    abstract protected function getOutputFileName();

    abstract protected function getExportContentType();

    abstract protected function outputHeader($headers);

    abstract protected function outputData($entries);

    protected function closeOutput()
    {
        //in general no implementation is needed, but in some cases it might be used
        //as a hook method
    }

}
