<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouImport_CSVWriter_Writer extends ITS4YouImport_FileWriter_Writer
{

    protected function outputData($entries)
    {
        foreach ($entries as $row) {
            $line = implode("\",\"", $row);
            $line = "\"" . $line;
            $line .= "\"\r\n";
            echo $line;
        }
    }

    protected function outputHeader($headers)
    {
        $header = implode("\", \"", $headers);
        $header = "\"" . $header;
        $header .= "\"\r\n";
        echo $header;
    }

    protected function getExportContentType()
    {
        return "text/csv";
    }

    protected function getOutputFileName()
    {
        return $this->fileName . ".csv";
    }

}
