<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouImport_Popup_View extends Vtiger_Popup_View
{

    public function __construct()
    {
        $this->exposeMethod('getImportDetails');
    }

    public function process(Vtiger_Request $request)
    {
        //update for calendar 600.700.1.1
        $this->updateTargetModule($request);
        $viewer = $this->getViewer($request);
        $mode = $request->get('mode');

        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
        } else {

            $this->initializeListViewContents($request, $viewer);
            $moduleName = $request->get('targetModule');

            $companyDetails = Vtiger_CompanyDetails_Model::getInstanceById();
            $companyLogo = $companyDetails->getLogo();
            $viewer->assign('COMPANY_LOGO', $companyLogo);

            $viewer->view('Popup.tpl', $moduleName);
        }
    }

    public function updateTargetModule(Vtiger_Request $request)
    {
        $moduleName = $request->get('targetModule');

        if ('Events' === $moduleName) {
            $request->set('targetModule', 'Calendar');
        }
    }

    /*
     * Function to initialize the required data in smarty to display the List View Contents
     */
    public function initializeListViewContents(Vtiger_Request $request, Vtiger_Viewer $viewer)
    {
        $moduleName = $request->get('targetModule');
        $cvId = $request->get('viewname');
        $pageNumber = $request->get('page');
        $orderBy = $request->get('orderby');
        $sortOrder = $request->get('sortorder');
        if ($sortOrder == "ASC") {
            $nextSortOrder = "DESC";
            $sortImage = "downArrowSmall.png";
        } else {
            $nextSortOrder = "ASC";
            $sortImage = "upArrowSmall.png";
        }
        if (empty($pageNumber)) {
            $pageNumber = '1';
        }

        $moduleModel = Vtiger_Module_Model::getInstance($moduleName);
        $listViewModel = Import_ListView_Model::getInstance($moduleName, $cvId);
        $recordStructureInstance = Vtiger_RecordStructure_Model::getInstanceForModule($moduleModel);

        $pagingModel = new Vtiger_Paging_Model();
        $pagingModel->set('page', $pageNumber);

        if (!empty($orderBy)) {
            $listViewModel->set('orderby', $orderBy);
            $listViewModel->set('sortorder', $sortOrder);
        }
        if (!$this->listViewHeaders) {
            $this->listViewHeaders = $listViewModel->getListViewHeaders();
        }
        if (!$this->listViewEntries) {
            $this->listViewEntries = $listViewModel->getListViewEntries($pagingModel);
        }
        $noOfEntries = count($this->listViewEntries);
        $viewer->assign('MODULE', $moduleName);


        $viewer->assign('PAGING_MODEL', $pagingModel);
        $viewer->assign('PAGE_NUMBER', $pageNumber);

        $viewer->assign('RECORD_STRUCTURE_MODEL', $recordStructureInstance);
        $viewer->assign('RECORD_STRUCTURE', $recordStructureInstance->getStructure());

        $viewer->assign('ORDER_BY', $orderBy);
        $viewer->assign('SORT_ORDER', $sortOrder);
        $viewer->assign('NEXT_SORT_ORDER', $nextSortOrder);
        $viewer->assign('SORT_IMAGE', $sortImage);
        $viewer->assign('COLUMN_NAME', $orderBy);

        $viewer->assign('LISTVIEW_ENTRIES_COUNT', $noOfEntries);
        $viewer->assign('LISTVIEW_HEADERS', $this->listViewHeaders);
        $viewer->assign('LISTVIEW_ENTRIES', $this->listViewEntries);
        $viewer->assign('CURRENT_USER_MODEL', Users_Record_Model::getCurrentUserModel());
    }

    public function getImportDetails(Vtiger_Request $request)
    {
        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();
        $targetModule = $request->get("targetModule");
        $importId = $request->get("import_entity_id");

        $importRecords = ITS4YouImport_Data_Action::getImportDetailsEnhanced($importId, $request->get("foruser"), $targetModule);
        $viewer->assign('IMPORT_RECORDS', $importRecords);
        $viewer->assign('TYPE', $request->get('type'));
        $viewer->assign('MODULE', $moduleName);
        $viewer->assign('RECORD', $importId);
        $viewer->assign('TARGET_MODULE', $targetModule);

        $viewer->view('PopupImportDetails.tpl', $moduleName);
    }

}
