<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouImport_Main_View extends Import_Main_View
{

    /** @var ITS4YouImport_Logger_Model Logger instance retrieved from ITS4YouImport_Data_Action after import */
    private static $logger = null;

    /** @var ITS4YouImport_Record_Model */
    private $importEntity = null;

    public static function import($request, $user)
    {
        $importController = new ITS4YouImport_Main_View($request, $user);
        $importController->saveImportEntity();
        $importController->saveMap();
        $fileReadStatus = $importController->copyFromFileToDB();
        if ($fileReadStatus) {
            $importController->queueDataImport();
        }

        $isImportScheduled = $importController->request->get('is_scheduled');

        if ($isImportScheduled) {
            $importInfo = ITS4YouImport_Queue_Action::getUserCurrentImportInfo($importController->user);
            self::showScheduledStatus($importInfo);
        } else {
            $importController->triggerImport();
        }
    }

    private function saveImportEntity()
    {
        global $VTIGER_BULK_SAVE_MODE;
        $previous_VTIGER_BULK_SAVE_MODE = $VTIGER_BULK_SAVE_MODE;
        $VTIGER_BULK_SAVE_MODE = false;

        $this->importEntity = Vtiger_Record_Model::getCleanInstance("ITS4YouImport");
        $this->importEntity->set("mode", "");
        $modelData = $this->importEntity->getData();

        switch ($this->request->get("merge_type")) {
            case ITS4YouImport_Utils_Helper::$AUTO_MERGE_NONE:
                $mergeType = ITS4YouImport_Module_Model::$FIELD_MERGE_TYPE_NONE;
                break;
            case ITS4YouImport_Utils_Helper::$AUTO_MERGE_IGNORE:
                $mergeType = ITS4YouImport_Module_Model::$FIELD_MERGE_TYPE_SKIP;
                break;
            case ITS4YouImport_Utils_Helper::$AUTO_MERGE_OVERWRITE:
                $mergeType = ITS4YouImport_Module_Model::$FIELD_MERGE_TYPE_OVERWRITE;
                break;
            case ITS4YouImport_Utils_Helper::$AUTO_MERGE_MERGEFIELDS:
                $mergeType = ITS4YouImport_Module_Model::$FIELD_MERGE_TYPE_MERGE;
                break;
        }

        if ($this->request->get("trigger_workflow") === "on") {
            $trigger_wf = '1';
        } else {
            $trigger_wf = '0';
        }

        if ($this->request->get("create_picklist_values") === "on") {
            $create_picklist_vals = '1';
        } else {
            $create_picklist_vals = '0';
        }

        $field_mapping = $this->request->get("field_mapping");
        $targetModule = $this->request->get('targetModule');

        $this->importEntity->set("importname", $this->request->get("importname"));
        $this->importEntity->set("target_module", $targetModule);
        $this->importEntity->set("field_mapping", Zend_Json::encode($field_mapping));
        $this->importEntity->set("default_values", Zend_Json::encode($this->request->get("default_values")));
        $this->importEntity->set("merge_type", $mergeType);
        $this->importEntity->set("merge_fields", Zend_Json::encode($this->request->get("merge_fields")));
        $this->importEntity->set("trigger_wf", $trigger_wf);
        $this->importEntity->set("create_picklist_vals", $create_picklist_vals);
        $this->importEntity->set("import_status", ITS4YouImport_Module_Model::$FIELD_IMPORT_STATUS_NONE);
        $this->importEntity->set("filename", $this->request->get("filename"));
        $this->importEntity->set("filetype", $this->request->get("type"));
        $this->importEntity->set("fileencoding", $this->request->get("file_encoding"));
        $this->importEntity->set("delimiter", $this->request->get("delimiter"));
        $this->importEntity->set("has_header", $this->request->get("has_header"));
        $this->importEntity->save();

        $this->request->set("import_entity_id", $this->importEntity->getId());

        $VTIGER_BULK_SAVE_MODE = $previous_VTIGER_BULK_SAVE_MODE;
    }

    public function saveMap()
    {
        $saveMap = $this->request->get('save_map');
        $mapName = $this->request->get('save_map_as');
        if ($saveMap && !empty($mapName)) {
            $fieldMapping = $this->request->get('field_mapping');
            $fileReader = ITS4YouImport_Utils_Helper::getFileReader($this->request, $this->user);
            if ($fileReader == null) {
                return false;
            }
            $hasHeader = $fileReader->hasHeader();
            if ($hasHeader) {
                $firstRowData = $fileReader->getFirstRowData($hasHeader);
                $headers = array_keys($firstRowData);
                foreach ($fieldMapping as $fieldName => $index) {
                    $saveMapping["$headers[$index]"] = $fieldName;
                }
            } else {
                $saveMapping = array_flip($fieldMapping);
            }

            $map = array();
            $map['name'] = $mapName;
            $map['content'] = $saveMapping;
            $map['module'] = $this->request->get('targetModule');
            $map['has_header'] = ($hasHeader) ? 1 : 0;
            $map['assigned_user_id'] = $this->user->id;

            $importMap = new ITS4YouImport_Map_Model($map, $this->user);
            $importMap->save();
        }
    }

    public function copyFromFileToDB()
    {
        $fileReader = ITS4YouImport_Utils_Helper::getFileReader($this->request, $this->user);

        /* @var $fileReader Import_FileReader_Reader */
        $fileReader->read();
        $fileReader->deleteFile();

        if ($fileReader->getStatus() == 'success') {
            $this->numberOfRecords = $fileReader->getNumberOfRecordsRead();
            return true;
        }

        ITS4YouImport_Utils_Helper::showErrorPage(vtranslate('ERR_FILE_READ_FAILED', 'ITS4YouImport'));
        return false;
    }

    public function queueDataImport()
    {
        $configReader = new ITS4YouImport_Config_Model();
        $immediateImportRecordLimit = $configReader->get('immediateImportLimit');

        $numberOfRecordsToImport = $this->numberOfRecords;
        if ($numberOfRecordsToImport > $immediateImportRecordLimit && $this->request->get('bypassBackgroundImport') == 'false') {
            $this->request->set('is_scheduled', true);
        }

        ITS4YouImport_Queue_Action::add($this->request, $this->user);
    }

    public static function showScheduledStatus($importInfo, $enableCronStatus = null)
    {
        $moduleName = $importInfo['module'];
        $importId = $importInfo['id'];

        $viewer = new Vtiger_Viewer();

        $viewer->assign('ERROR_MESSAGE', '');
        $viewer->assign('FOR_MODULE', $moduleName);
        $viewer->assign('MODULE', 'ITS4YouImport');
        $viewer->assign('IMPORT_ID', $importId);
        $viewer->assign('STEP', '3');

        $viewer->view('ImportSchedule.tpl', 'ITS4YouImport');
    }

    public function triggerImport($batchImport = false)
    {
        $importInfo = ITS4YouImport_Queue_Action::getImportInfo($this->request->get('targetModule'), $this->user);
        $importDataController = new ITS4YouImport_Data_Action($importInfo, $this->user);

        if (!$batchImport && !$importDataController->initializeImport()) {
            ITS4YouImport_Utils_Helper::showErrorPage(vtranslate('ERR_FAILED_TO_LOCK_MODULE', 'ITS4YouImport'));
        } else {
            $importDataController->importData();
            ITS4YouImport_Queue_Action::updateStatus($importInfo['id'], ITS4YouImport_Queue_Action::$IMPORT_STATUS_HALTED);
            $importInfo = ITS4YouImport_Queue_Action::getImportInfo($this->request->get('targetModule'), $this->user);

            self::showImportStatus($importInfo, $this->user);
        }
    }

    public static function showImportStatus($importInfo, $user)
    {
        if ($importInfo == null) {
            ITS4YouImport_Utils_Helper::showErrorPage(vtranslate('ERR_IMPORT_INTERRUPTED', 'ITS4YouImport'));
        } else {
            $importDataController = new ITS4YouImport_Data_Action($importInfo, $user);
            /* @var $importDataController ITS4YouImport_Data_Action */
            if ($importInfo['status'] == ITS4YouImport_Queue_Action::$IMPORT_STATUS_HALTED || $importInfo['status'] == ITS4YouImport_Queue_Action::$IMPORT_STATUS_NONE) {
                $continueImport = true;
            } else {
                $continueImport = false;
            }

            $focus = CRMEntity::getInstance($importInfo['module']);
            if (method_exists($focus, 'getImportStatusCount')) {
                $importStatusCount = $focus->getImportStatusCount($importDataController);
            } else {
                $importStatusCount = $importDataController->getImportStatusCount();
            }
            $totalRecords = $importStatusCount['TOTAL'];

            if ($totalRecords > ($importStatusCount['IMPORTED'] + $importStatusCount['FAILED'])) {
                self::showCurrentStatus($importInfo, $importStatusCount, $continueImport);
            } else {
                $importDataController->finishImport();
                self::$logger = $importDataController->getLogger();
                self::showResult($importInfo, $importStatusCount);
            }
        }
    }

    public static function showCurrentStatus($importInfo, $importStatusCount, $continueImport)
    {
        $moduleName = $importInfo['module'];
        $importId = $importInfo['id'];

        $viewer = new Vtiger_Viewer();
        $viewer->assign('ERROR_MESSAGE', '');
        $viewer->assign('FOR_MODULE', $moduleName);
        $viewer->assign('MODULE', 'ITS4YouImport');
        $viewer->assign('IMPORT_ID', $importId);
        $viewer->assign('IMPORT_RESULT', $importStatusCount);
        $viewer->assign('INVENTORY_MODULES', getInventoryModules());
        $viewer->assign('CONTINUE_IMPORT', $continueImport);
        $viewer->assign('MERGE_ENABLED', $importInfo['merge_type']);
        $viewer->assign('STEP', '3');

        $viewer->view('ImportStatus.tpl', 'ITS4YouImport');
    }

    public static function showResult($importInfo, $importStatusCount)
    {

        $moduleName = $importInfo['module'];
        $ownerId = $importInfo['user_id'];
        $viewer = new Vtiger_Viewer();

        $viewer->assign('FOR_MODULE', $moduleName);
        $viewer->assign('MODULE', 'ITS4YouImport');
        $viewer->assign('OWNER_ID', $ownerId);
        $viewer->assign('IMPORT_RESULT', $importStatusCount);
        $viewer->assign('INVENTORY_MODULES', getInventoryModules());
        $viewer->assign('MERGE_ENABLED', $importInfo['merge_type']);
        $viewer->assign('SOURCE_RECORD', $importInfo['source_record']);
        $viewer->assign('STEP', '4');
        $viewer->assign('IMPORT_ENTITY_ID', $importInfo['import_entity_id']);

        $viewer->view('ImportResult.tpl', 'ITS4YouImport');
    }

    public static function deleteMap($request)
    {
        $moduleName = $request->get("targetModule");
        $mapId = $request->get('mapid');
        if (!empty($mapId)) {
            ITS4YouImport_Map_Model::markAsDeleted($mapId);
        }

        $viewer = new Vtiger_Viewer();
        $viewer->assign('FOR_MODULE', $moduleName);
        $viewer->assign('MODULE', 'ITS4YouImport');
        $viewer->assign('SAVED_MAPS', ITS4YouImport_Map_Model::getAllByModule($moduleName));
        $viewer->view('EditStep2_Saved_Maps.tpl', 'ITS4YouImport');
    }

}
