<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouImport_VCardReader_Reader extends Import_VCardReader_Reader
{

    public function __construct($request, $user)
    {
        parent::__construct($request, $user);
    }

    /** Function returns the database column type of the field
     * @param $fieldObject <Vtiger_Field_Model>
     * @param $fieldTypes <Array> - fieldnames with column type
     * @return <String> - column name with type for sql creation of table
     */
    public function getDBColumnType($fieldObject, $fieldTypes)
    {
        $columnsListQuery = '';
        $fieldName = $fieldObject->getName();
        $dataType = $fieldObject->getFieldDataType();
        //added additional data types in order to handle type check at later phase (avoid)
        //automatic DB conversion rules wo any message
        $skipDataType = array('reference', 'owner', 'currencyList', 'date', 'datetime', 'integer', 'double', 'currency', 'percentage');
        if (in_array($dataType, $skipDataType)) {
            $columnsListQuery .= ',' . $fieldName . ' varchar(250)';
        } else {
            $columnsListQuery .= ',' . $fieldName . ' ' . $fieldTypes[$fieldObject->get('column')];
        }

        return $columnsListQuery;
    }

    /**
     * Returns number of records which are to be read - before full reading
     * @return int Number of records to be read
     */
    public function getNumberOfRecordsToBeRead()
    {
        $filePath = $this->getFilePath();

        if (empty(self::$fileContents)) {
            self::$fileContents = file_get_contents($filePath);
        }
        $fileContents = self::$fileContents;

        $matches = array();
        preg_match_all($this->vCardPattern, $fileContents, $matches);

        return count($matches[0]);
    }

    public function getRowByNumber($rows = array())
    {
        global $default_charset;

        $filePath = $this->getFilePath();
        if (empty(self::$fileContents)) {
            self::$fileContents = file_get_contents($filePath);
        }
        $fileContents = self::$fileContents;

        $data = null;
        $matches = array();
        preg_match_all($this->vCardPattern, $fileContents, $matches);

        $row = $matches[0][0];
        $fieldValueMappings = explode("\r\n", $row);
        $data = array();
        foreach ($fieldValueMappings as $fieldValueMapping) {
            list($label, $value) = explode(':', $fieldValueMapping, 2);
            $value = str_replace(';', ' ', $value);
            if (!in_array($label, $this->skipLabels)) {
                $data[$label] = $this->convertCharacterEncoding($value, $this->request->get('file_encoding'), $default_charset);
            }
        }
        return $data;
    }

}
