<?php

class ITS4YouImport_FileReader_Reader extends Import_FileReader_Reader
{

    public function createTable()
    {
        $db = PearDatabase::getInstance();

        $tableName = Import_Utils_Helper::getDbTableName($this->user);
        $fieldMapping = $this->request->get('field_mapping');
        $targetModule = $this->request->get('targetModule');
        $sourceRecord = $this->request->get('sourceRecord');
        $columnsListQuery = 'id INT PRIMARY KEY AUTO_INCREMENT, status INT DEFAULT 0, recordid INT';

        if ($targetModule === 'PriceBooks' && isRecordExists($sourceRecord)) {
            $columnsListQuery .= ', price DECIMAL(25,8), identifier VARCHAR(100) ';
        } else {
            $moduleFields = $this->moduleModel->getFields();
            $fieldTypes = $this->getModuleFieldDBColumnType();
            if (method_exists($this->moduleModel, 'getAdditionalImportFields')) {
                $moduleImportableFields = $this->moduleModel->getAdditionalImportFields();
                $moduleFields = array_merge($moduleFields, $moduleImportableFields);
            }

            foreach ($fieldMapping as $fieldName => $index) {
                $fieldObject = $moduleFields[$fieldName];

                if ($fieldObject) {
                    $columnsListQuery .= $this->getDBColumnType($fieldObject, $fieldTypes);
                } elseif (ITS4YouImport_Utils_Helper::isReferenceField($fieldName)) {
                    $columnsListQuery .= ' , ' . $fieldName . ' VARCHAR(255) ';
                }
            }
        }

        $createTableQuery = 'CREATE TABLE IF NOT EXISTS ' . $tableName . ' (' . $columnsListQuery . ') ENGINE=MyISAM ';
        $db->query($createTableQuery);

        return true;
    }

    /**
     * @param array $columnNames
     * @param array $fieldValues
     * @return void
     */
    public function addRecordToDB($columnNames, $fieldValues)
    {
        $tableName = Import_Utils_Helper::getDbTableName($this->user);
        $newField = [];

        foreach ($fieldValues as $key => $fieldVal) {
            if ('' === $fieldVal || null === $fieldVal) {
                $newField[$key] = $fieldVal;
            } else {
                $newField[$key] = vtlib_purify(htmlspecialchars_decode($fieldVal, ENT_QUOTES));
            }
        }

        $fieldValues = $newField;
        PearDatabase::getInstance()->pquery('INSERT INTO ' . $tableName . ' (' . implode(',', $columnNames) . ') VALUES (' . generateQuestionMarks($fieldValues) . ')', $fieldValues);
        $this->numberOfRecordsRead++;
    }
}