<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouImport_CSVReader_Reader extends Import_CSVReader_Reader
{

    public function __construct($request, $user)
    {
        parent::__construct($request, $user);
    }

    /**
     * Returns number of records which are to be read - before full reading
     * @return int Number of records to be read
     */
    public function getNumberOfRecordsToBeRead()
    {
        $fileHandler = $this->getFileHandler();
        $highestRow = 0;
        while ($data = fgetcsv($fileHandler, 0, $this->request->get('delimiter'))) {
            $highestRow++;
        }
        unset($fileHandler);

        if ($this->hasHeader()) {
            $highestRow--;
        }

        return $highestRow;
    }

    public function getRowByNumber($rows = array())
    {
        global $default_charset;
        $result = array();

        $fileHandler = $this->getFileHandler();
        $firstRowData = array();
        $currentRow = 1;
        while ($data = fgetcsv($fileHandler, 0, $this->request->get('delimiter'), "\"", "\"")) {
            if (in_array($currentRow, $rows)) {
                foreach ($data as $key => $value) {
                    $firstRowData[$key] = trim($this->convertCharacterEncoding(strip_tags(decode_html($value)), $this->request->get('file_encoding'), $default_charset));
                }
                $result[$currentRow] = $firstRowData;
            }
            $currentRow++;
        }

        unset($fileHandler);

        return $result;
    }

    public function createTable()
    {
        $db = PearDatabase::getInstance();

        $tableName = Import_Utils_Helper::getDbTableName($this->user);
        $fieldMapping = $this->request->get('field_mapping');
        $targetModule = $this->request->get('targetModule');
        $sourceRecord = $this->request->get('sourceRecord');
        $columnsListQuery = 'id INT PRIMARY KEY AUTO_INCREMENT, status INT DEFAULT 0, recordid INT';

        if ($targetModule === 'PriceBooks' && isRecordExists($sourceRecord)) {
            $columnsListQuery .= ', price DECIMAL(25,8), identifier VARCHAR(100) ';
        } else {
            $moduleFields = $this->moduleModel->getFields();
            $fieldTypes = $this->getModuleFieldDBColumnType();
            if (method_exists($this->moduleModel, 'getAdditionalImportFields')) {
                $moduleImportableFields = $this->moduleModel->getAdditionalImportFields();
                $moduleFields = array_merge($moduleFields, $moduleImportableFields);
            }

            foreach ($fieldMapping as $fieldName => $index) {
                $fieldObject = $moduleFields[$fieldName];

                if ($fieldObject) {
                    $columnsListQuery .= $this->getDBColumnType($fieldObject, $fieldTypes);
                } elseif (ITS4YouImport_Utils_Helper::isReferenceField($fieldName)) {
                    $columnsListQuery .= ' , ' . $fieldName . ' VARCHAR(255) ';
                }
            }
        }

        $createTableQuery = 'CREATE TABLE ' . $tableName . ' (' . $columnsListQuery . ') ENGINE=MyISAM ';
        $db->query($createTableQuery);
        return true;
    }

    /** Function returns the database column type of the field
     * @param $fieldObject <Vtiger_Field_Model>
     * @param $fieldTypes <Array> - fieldnames with column type
     * @return <String> - column name with type for sql creation of table
     */
    public function getDBColumnType($fieldObject, $fieldTypes)
    {
        $columnsListQuery = '';
        $fieldName = $fieldObject->getName();
        $dataType = $fieldObject->getFieldDataType();
        //added additional data types in order to handle type check at later phase (avoid)
        //automatic DB conversion rules wo any message
        $skipDataType = array('reference', 'owner', 'currencyList', 'date', 'datetime', 'integer', 'double', 'currency', 'percentage');
        if (in_array($dataType, $skipDataType)) {
            $columnsListQuery .= ',' . $fieldName . ' varchar(250)';
        } else {
            $columnsListQuery .= ',' . $fieldName . ' ' . $fieldTypes[$fieldObject->get('column')];
        }

        return $columnsListQuery;
    }
}
