<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouImport_Record_Model extends Vtiger_Record_Model
{

    public static function updateStatus($recordId, $newStatus)
    {
        $db = PearDatabase::getInstance();
        $db->pquery("UPDATE its4you_imports SET import_status = ? WHERE importid = ?", array($newStatus, $recordId));
    }

    public static function updateCounters($recordId, $importStatusCount)
    {
        $db = PearDatabase::getInstance();
        $db->pquery("UPDATE its4you_imports SET count_total=?, count_ok=?, count_fail=? WHERE importid=?", array(
            $importStatusCount['TOTAL'],
            $importStatusCount['IMPORTED'],
            $importStatusCount['FAILED'],
            $recordId
        ));
    }

    /**
     * Function to get details for user have the permissions to do actions
     * @return <Boolean> - true/false
     */
    public function isEditable()
    {
        return false;
    }

    public function isLogLinkDownloadable()
    {
        $logger = ITS4YouImport_Logger_Model::factory($this->getId(), Users_Record_Model::getCurrentUserModel()->getId());
        /* @var $logger ITS4YouImport_Logger_Model */
        $logEntries = $logger->getLogEntries();

        return !empty($logEntries);
    }

    public function getDownloadLogUrl()
    {
        return "index.php?module=" . $this->getModuleName() . "&action=DownloadFailed&import_entity_id=" . $this->getId();
    }

}
