<?php
/* * *******************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouImport_LogMessage_Model
{

    public static $LOG_MSG_TYPE_ALL = '*';
    public static $LOG_MSG_TYPE_ERROR = 'E';
    public static $LOG_MSG_TYPE_SUCCESS = 'S';
    public static $LOG_MSG_TYPE_INFO = 'I';
    public static $LOG_MSG_TYPE_WARNING = 'W';
    protected $type;
    protected $message;
    protected $timeStamp;
    protected $msgParams;

    public function __construct($type, $message, $msgParams = array())
    {
        $this->message = $message;
        $this->type = $type;
        $this->timeStamp = time();
        $this->msgParams = $msgParams;
    }

    public function getType()
    {
        return $this->type;
    }

    public function getMessageText()
    {
        $translatedMessage = vtranslate($this->message, "ITS4YouImport");
        $idx = 1;
        foreach ($this->msgParams as $msgParam) {
            $translatedMessage = str_replace("&" . $idx, $msgParam, $translatedMessage);
            $idx++;
        }

        return $translatedMessage;
    }

}

abstract class ITS4YouImport_LogEntryBase_Model
{

    /** @var array(char, string) log entry messages */
    protected $messages = array();

    public function addLogMessage($messageType, $message, $msgParams = array())
    {
        $this->messages[] = new ITS4YouImport_LogMessage_Model($messageType, $message, $msgParams);
    }

    public function addLogMessageModel(ITS4YouImport_LogMessage_Model $logMessageModel)
    {
        $this->messages[] = $logMessageModel;
    }

    /**
     * Returns one or more log messages based on selected message type
     * @param ITS4YouImport_LogMessage_Model::$LOG_MSG_TYPE_ERROR etc.
     * @param bool $onlyFirst
     * @return mixed Messages
     */
    public function getLogMessage($messageType = 'E', $onlyFirst = true)
    {
        if ($messageType == ITS4YouImport_LogMessage_Model::$LOG_MSG_TYPE_ALL) {
            if ($onlyFirst) {
                return $this->messages[0];
            } else {
                return $this->messages;
            }
        } else {
            if ($onlyFirst) {
                foreach ($this->messages as $logMessage) {
                    /* @var $logMessage ITS4YouImport_LogMessage_Model */
                    if ($logMessage->getType() == $messageType) {
                        return $logMessage;
                    }
                }
                return null;
            } else {
                $logMessages = array();
                foreach ($this->messages as $logMessage) {
                    /* @var $logMessage ITS4YouImport_LogMessage_Model */
                    if ($logMessage->getType() == $messageType) {
                        $logMessages[] = $logMessage;
                    }
                }
                return $logMessages;
            }
        }
    }

    public function isNotOK()
    {
        foreach ($this->messages as $message) {
            /* @var $message ITS4YouImport_LogMessage_Model */
            if ($message->getType() === ITS4YouImport_LogMessage_Model::$LOG_MSG_TYPE_ERROR || $message->getType() === ITS4YouImport_LogMessage_Model::$LOG_MSG_TYPE_WARNING) {
                return true;
            }
        }

        return false;
    }

    /**
     * Abstract method which introduce requirement for uniqueness of log entries
     */
    abstract public function getId();
}
