<?php
/* * *******************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouImport_DataLogEntry_Model extends ITS4YouImport_LogEntryBase_Model
{

    protected $itemId;
    protected $itemData;
//    protected $entityInfo;
    protected $entityId;
    protected $entityStatus;

    public function __construct($itemId, $itemData)
    {
        $this->itemId = $itemId;
        $this->itemData = $itemData;
    }

    public function addEntityInfo($entityInfo)
    {
        if ($entityInfo != null) {
            $this->entityId = $entityInfo['id'];
            $this->entityStatus = $entityInfo['status'];
        } else {
            $this->addLogMessage(ITS4YouImport_LogMessage_Model::$LOG_MSG_TYPE_ERROR, "LBL_UNKNOWN_ERROR");
        }
    }

    public function getEntityId()
    {
        return $this->entityInfo['id'];
    }

    public function getEntityStatus()
    {
        return $this->entityInfo['status'];
    }

    public function getId()
    {
        return $this->itemId;
    }

    public function getItemData()
    {
        return $this->itemData;
    }

    public function setItemData($itemData)
    {
        $this->itemData = $itemData;
    }

}
