<?php
/* * *******************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouImport_ChunkReadFilter_Filter implements PHPExcel_Reader_IReadFilter
{

    /** @var ITS4YouImport_Config_Model */
    private $config;
    private $startRow = 0;
    private $endRow = 0;

    public function __construct()
    {
        $this->config = new ITS4YouImport_Config_Model();
    }

    public function readCell($column, $row, $worksheetName = '')
    {
        //  Only read the heading row, and the rows that are configured in $this->_startRow and $this->_endRow
        if (($row == 1) || ($row >= $this->startRow && $row < $this->endRow)) {
            return true;
        }
        return false;
    }

    public function setStartRow($startRow)
    {
        $this->startRow = $startRow;
        $this->endRow = $this->startRow + $this->config->get("importBatchLimit");
    }

}