<?php
/* * *******************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouImport_GetMergeFields_Action extends Vtiger_BasicAjax_Action
{

    public function process(Vtiger_Request $request)
    {
        $targetModuleName = $request->get("targetModule");
        $response = new Vtiger_Response();

        $duplicateHandlingNotSupportedModules = ITS4YouImport_Utils_Helper::getUnsupportedModulesForDuplicateHandling();
        if (!in_array($targetModuleName, $duplicateHandlingNotSupportedModules)) {
            $targetModuleModel = Vtiger_Module_Model::getInstance($targetModuleName);
            if ($targetModuleModel) {
                $targetModuleMeta = $targetModuleModel->getModuleMeta();
                $availableFields = ITS4YouImport_Utils_Helper::getMergableFields($targetModuleMeta);
                $entityFields = array_keys($targetModuleMeta->getEntityFields());
                $result = array();
                foreach ($availableFields as $fieldName => $fieldModel) {
                    $result[$fieldName] = array(
                        "displayValue" => vtranslate($fieldModel->getFieldLabelKey(), $targetModuleModel->getName()),
                        "selectedAttribute" => (in_array($fieldName, $entityFields) ? "selected" : ""),
                        "dataAttribute" => (in_array($fieldName, $entityFields) ? 'data-is_default="true"' : "")
                    );
                }

                $response = new Vtiger_Response();
                $response->setResult($result);
            } else {
                $response->setError(500, vtranslate("LBL_GET_FIELDS_ERROR", $request->get("module")));
            }
        } else {
            $response->setError(501, vtranslate("LBL_UNSUPPORTED_MODULE_FOR_DUPLHAND", $request->get("module")));
        }
        $response->emit();
    }

}
