/* * *******************************************************************************
 * The content of this file is subject to the CreditNotes4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

if ('undefined' !== typeof Vtiger_Base_Validator_Js) {
	Vtiger_Base_Validator_Js("CreditNotes4You_Number_Validator_Js", {

		/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */
		invokeValidation: function (field, rules, i, options) {
			var NumberInstance = new CreditNotes4You_Number_Validator_Js();
			NumberInstance.setElement(field);
			var response = NumberInstance.validate();
			if (response != true) {
				return NumberInstance.getError();
			}
		}

	}, {

		/**
		 * Function to validate the Positive Numbers
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */
		validate: function () {
			var fieldValue = this.getFieldValue();
			if (isNaN(fieldValue)) {
				var errorInfo = app.vtranslate('INVALID_NUMBER');
				this.setError(errorInfo);
				return false;
			}
			return true;
		}
	});
}