<?php

/* * *******************************************************************************
 * The content of this file is subject to the CreditNotes4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

/**
 * Inventory Record Model Class
 */
class CreditNotes4You_Record_Model extends Inventory_Record_Model {

    function getProducts() {
        $relatedProducts = CreditNotes4You_Inventory_Helper::getAssociatedProducts($this->getModuleName(), $this->getEntity());
        $productsCount = count($relatedProducts);

        //Updating Pre tax total
        $preTaxTotal = (float) $relatedProducts[1]['final_details']['hdnSubTotal'] + (float) $relatedProducts[1]['final_details']['shipping_handling_charge'] - (float) $relatedProducts[1]['final_details']['discountTotal_final'];

        $relatedProducts[1]['final_details']['preTaxTotal'] = number_format($preTaxTotal, getCurrencyDecimalPlaces(), '.', '');

        //Updating Total After Discount
        $totalAfterDiscount = (float) $relatedProducts[1]['final_details']['hdnSubTotal'] - (float) $relatedProducts[1]['final_details']['discountTotal_final'];

        $relatedProducts[1]['final_details']['totalAfterDiscount'] = number_format($totalAfterDiscount, getCurrencyDecimalPlaces(), '.', '');

        //charge value setting to related products array
        $relatedProducts[1]['final_details']['chargesAndItsTaxes'] = $this->getCharges() ?: array();

        //Updating Tax details
        $taxtype = $relatedProducts[1]['final_details']['taxtype'];
        $entity  = $this->getEntity();
        $db = PearDatabase::getInstance();
        
        for ($i = 1; $i <= $productsCount; $i++) {
            $product = $relatedProducts[$i];
            $productId = $product['hdnProductId' . $i];
            $totalAfterDiscount = $product['totalAfterDiscount' . $i];

            if( Vtiger_Module::getInstance("ITS4YouDiscounts") != false )
            {
                //$product_Detail[$i]['prod_rabatt'] = "|" . implode("|", explode(" |##| ", $prod_rabatt)) . "|";
                require_once('modules/ITS4YouDiscounts/ITS4YouDiscounts.php');
                $product['discounts'] = ITS4YouDiscounts::getDiscountsInventory($productId, $entity->column_fields["account_id"] );
                $result = $db->pquery("SELECT lineitem_id FROM  vtiger_inventoryproductrel WHERE id=? AND productid =? AND sequence_no=?",Array($entity->column_fields["record_id"],$productId,$i ));
                $lineitem_id = $db->query_result($result, 0, 'lineitem_id');
                $product['productDiscountPercent' . $i] = ITS4YouDiscounts::getDiscountPercentageForLineitem($lineitem_id);
                $accountProductRabatt = roundValueSpecific(ITS4YouDiscounts::getDiscountValueForLineitem($lineitem_id, $product['productTotal'.$i]), $entity->column_fields["record_id"]);
                $product['productDiscountAmount' . $i] = $accountProductRabatt;
               // $product['productTotal'.$i] -= $accountProductRabatt;
                $totalAfterDiscount -= $accountProductRabatt;
                $product['totalAfterDiscount'.$i] = $totalAfterDiscount;

                $product['netPrice'.$i] = $totalAfterDiscount;
            }
            
            if ($taxtype == 'individual') {
                $taxDetails = getTaxDetailsForProduct($productId, 'all');
                $taxCount = count($taxDetails);
                $taxTotal = '0.00';

                for ($j = 0; $j < $taxCount; $j++) {
                    $taxValue = $product['taxes'][$j]['percentage'];

                    $taxAmount = $totalAfterDiscount * $taxValue / 100;
                    $taxTotal = $taxTotal + $taxAmount;

                    $product['taxes'][$j]['amount'] = $taxAmount;
                    $product['taxTotal' . $i] = $taxTotal;
                }
                $netPrice = $totalAfterDiscount + $taxTotal;
                $product['netPrice' . $i] = $netPrice;
            }
            $relatedProducts[$i] = $product;
        }
        return $relatedProducts;
    }

    function getCurrencyInfo() {
        $moduleName = $this->getModuleName();
        $currencyInfo = CreditNotes4You_Inventory_Helper::getInventoryCurrencyInfo($moduleName, $this->getId());
        return $currencyInfo;
    }

    function getProductTaxes() {
        $taxDetails = $this->get('taxDetails');
        if ($taxDetails) {
            return $taxDetails;
        }

        $record = $this->getId();
        if ($record) {
            $relatedProducts = CreditNotes4You_Inventory_Helper::getAssociatedProducts($this->getModuleName(), $this->getEntity());
            $taxDetails = $relatedProducts[1]['final_details']['taxes'];
        } else {
            $taxDetails = getAllTaxes('available', '', $this->getEntity()->mode, $this->getId());
        }

        $this->set('taxDetails', $taxDetails);
        return $taxDetails;
    }

    function getShippingTaxes() {
        $shippingTaxDetails = $this->get('shippingTaxDetails');
        if ($shippingTaxDetails) {
            return $shippingTaxDetails;
        }

        $record = $this->getId();
        if ($record) {
            $relatedProducts = CreditNotes4You_Inventory_Helper::getAssociatedProducts($this->getModuleName(), $this->getEntity());
            $shippingTaxDetails = $relatedProducts[1]['final_details']['sh_taxes'];
        } else {
            $shippingTaxDetails = getAllTaxes('available', 'sh', 'edit', $this->getId());
        }

        $this->set('shippingTaxDetails', $shippingTaxDetails);
        return $shippingTaxDetails;
    }
}