<?php
/* * *******************************************************************************
 * The content of this file is subject to the CreditNotes4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class CreditNotes4You_ProductsUpdate_Helper {

    /**
     * update given qtyInStock value with qty value by stage of update ( + or - )
     *
     * @param $qtyInStock
     * @param $qty
     * @param $stage
     *
     * @return mixed
     */
    private static function getUpdatedQtyInStockByStage($qtyInStock, $qty, $stage) {
        switch ($stage) {
            case 'Refunded':
                $qtyInStock += $qty;
                break;
            default:
                $qtyInStock -= $qty;
                break;
        }

        return $qtyInStock;
    }


    public static function updateInventoryProductsByStatus($entityId, $status) {
        $recordModel = Inventory_Record_Model::getInstanceById($entityId);
        if ($recordModel) {
            $productDetails = $recordModel->getProducts();
            foreach ($productDetails as $ri => $lineItem) {
                if ('Products' === $lineItem['entityType' . $ri]) {
                    $productId = $lineItem['hdnProductId' . $ri];
                    $qty = $lineItem['qty' . $ri];

                    $productModuleName = 'Products';
                    $productModel = Vtiger_Record_Model::getInstanceById($productId, $productModuleName);
                    $qtyInStock = (float) ($productModel->get('qtyinstock') ? $productModel->get('qtyinstock') : 1);

                    if ($productModel->isBundle()) {
                        $subProducts = $productModel->getSubProducts($active = true);
                        foreach ($subProducts as $subItem) {
                            $subProductId = $subItem->getId();
                            if ('' !== $subItem->get('qtyinstock') && $subItem->get('qtyinstock') && is_numeric($subItem->get('qtyinstock'))) {
                                $subQtyInStock = (float) $subItem->get('qtyinstock');
                            } else {
                                $subQtyInStock = (float) 0;
                            }
                            if ('' !== $subItem->get('quantityInBundle') && $subItem->get('quantityInBundle') && is_numeric($subItem->get('quantityInBundle'))) {
                                $quantityInBundle = (float) $subItem->get('quantityInBundle');
                            } else {
                                $quantityInBundle = (float) 1;
                            }

                            $movedQuantity = $qty * $quantityInBundle;
                            $subQtyInStock = self::getUpdatedQtyInStockByStage($subQtyInStock, $movedQuantity, $status);
                            /** run update Product Qty */
                            updateProductQty($subProductId, $subQtyInStock);
                        }
                    } else {
                        $qtyInStock = self::getUpdatedQtyInStockByStage($qtyInStock, $qty, $status);
                        /** run update Product Qty */
                        updateProductQty($productId, $qtyInStock);
                    }
                }
            }
        }
    }
}

?>