<?php

/* * *******************************************************************************
 * The content of this file is subject to the CreditNotes4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class CreditNotes4You_Inventory_Helper {

    /** Function used to save the Inventory product details for the passed entity
     * 	@param object reference $focus - object reference to which we want to save the product details from REQUEST values where as the entity will be Credit Note
     * 	@param string $module - module name
     * 	@return void
     */
    public static function saveCreditNotes4YouInventoryProductDetails(&$focus, $module) {
        global $adb;
        $id = $focus->id;

        $ext_prod_arr = Array();
        if ($focus->mode == 'edit') {
            if ($_REQUEST['taxtype'] == 'group')
                $all_available_taxes = getAllTaxes('available', '', 'edit', $id);
            $return_old_values = 'return_old_values';

            //we will retrieve the existing product details and store it in a array and then delete all the existing product details and save new values, retrieve the old value and update stock only for SO, Quotes and Invoice not for PO
            //$ext_prod_arr = deleteInventoryProductDetails($focus->id,$return_old_values);
            deleteInventoryProductDetails($focus);
        }
        else {
            if ($_REQUEST['taxtype'] == 'group')
                $all_available_taxes = getAllTaxes('available', '', 'edit', $id);
        }
        $tot_no_prod = $_REQUEST['totalProductCount'];
        //If the taxtype is group then retrieve all available taxes, else retrive associated taxes for each product inside loop
        $prod_seq = 1;
        for ($i = 1; $i <= $tot_no_prod; $i++) {
            //if the product is deleted then we should avoid saving the deleted products
            if ($_REQUEST["deleted" . $i] == 1)
                continue;

            $prod_id = $_REQUEST['hdnProductId' . $i];
            if (isset($_REQUEST['productDescription' . $i]))
                $description = $_REQUEST['productDescription' . $i];
            $qty = $_REQUEST['qty' . $i];
            $listprice = $_REQUEST['listPrice' . $i];
            $comment = $_REQUEST['comment' . $i];

            if ($_REQUEST['lineItemType' . $i] != "Text") {
                $query = "insert into vtiger_inventoryproductrel(id, productid, sequence_no, quantity, listprice, comment, description) values(?,?,?,?,?,?,?)";
                $qparams = array($focus->id, $prod_id, $prod_seq, $qty, $listprice, $comment, $description);
            } else {
                $prod_text = $_REQUEST['prod_text' . $i];
                $query = "insert into vtiger_inventoryproductrel(id, productid, sequence_no, quantity, listprice, comment, description, prod_text) values(?,?,?,?,?,?,?,?)";
                $qparams = array($focus->id, $prod_id, $prod_seq, $qty, $listprice, $comment, $description, $prod_text);
            }
            $adb->pquery($query, $qparams);

            $sub_prod_str = $_REQUEST['subproduct_ids' . $i];
            if (!empty($sub_prod_str)) {
                $sub_prod = split(":", $sub_prod_str);
                for ($j = 0; $j < count($sub_prod); $j++) {
                    $query = "insert into vtiger_inventorysubproductrel(id, sequence_no, productid) values(?,?,?)";
                    $qparams = array($focus->id, $prod_seq, $sub_prod[$j]);
                    $adb->pquery($query, $qparams);
                }
            }
            $prod_seq++;

            //we should update discount and tax details
            $updatequery = "update vtiger_inventoryproductrel set ";
            $updateparams = array();

            //set the discount percentage or discount amount in update query, then set the tax values
            if ($_REQUEST['discount_type' . $i] == 'percentage') {
                $updatequery .= " discount_percent=?,";
                array_push($updateparams, $_REQUEST['discount_percentage' . $i]);
            } elseif ($_REQUEST['discount_type' . $i] == 'amount') {
                $updatequery .= " discount_amount=?,";
                $discount_amount = $_REQUEST['discount_amount' . $i];
                array_push($updateparams, $discount_amount);
            }
            if ($_REQUEST['taxtype'] == 'group') {
                for ($tax_count = 0; $tax_count < count($all_available_taxes); $tax_count++) {
                    $tax_name = $all_available_taxes[$tax_count]['taxname'];
                    $tax_val = $all_available_taxes[$tax_count]['percentage'];
                    $request_tax_name = $tax_name . "_group_percentage";
                    if (isset($_REQUEST[$request_tax_name]))
                        $tax_val = $_REQUEST[$request_tax_name];
                    $updatequery .= " $tax_name = ?,";
                    array_push($updateparams, $tax_val);
                }
                $updatequery = trim($updatequery, ',') . " where id=? and productid=?";
                array_push($updateparams, $focus->id, $prod_id);
            }
            else {
                $taxes_for_product = getTaxDetailsForProduct($prod_id, 'all');
                for ($tax_count = 0; $tax_count < count($taxes_for_product); $tax_count++) {
                    $tax_name = $taxes_for_product[$tax_count]['taxname'];
                    $request_tax_name = $tax_name . "_percentage" . $i;

                    $updatequery .= " $tax_name = ?,";
                    array_push($updateparams, $_REQUEST[$request_tax_name]);
                }
                $updatequery = trim($updatequery, ',') . " where id=? and productid=?";
                array_push($updateparams, $focus->id, $prod_id);
            }
            // jens 2006/08/19 - protect against empy update queries
            if (!preg_match('/set\s+where/i', $updatequery)) {
                $adb->pquery($updatequery, $updateparams);
            }
        }

        //we should update the netprice (subtotal), taxtype, group discount, S&H charge, S&H taxes, adjustment and total
        //netprice, group discount, taxtype, S&H amount, adjustment and total to entity table

        $updatequery = " update $focus->table_name set ";
        $updateparams = array();
        $subtotal = $_REQUEST['subtotal'];
        $updatequery .= " subtotal=?,";
        array_push($updateparams, $subtotal);

        $updatequery .= " taxtype=?,";
        array_push($updateparams, $_REQUEST['taxtype']);

        //for discount percentage or discount amount
        if ($_REQUEST['discount_type_final'] == 'percentage') {
            $updatequery .= " discount_percent=?,";
            array_push($updateparams, $_REQUEST['discount_percentage_final']);
        } elseif ($_REQUEST['discount_type_final'] == 'amount') {
            $discount_amount_final = $_REQUEST['discount_amount_final'];
            $updatequery .= " discount_amount=?,";
            array_push($updateparams, $discount_amount_final);
        }

        $shipping_handling_charge = $_REQUEST['shipping_handling_charge'];
        $updatequery .= " s_h_amount=?,";
        array_push($updateparams, $shipping_handling_charge);

        //if the user gave - sign in adjustment then add with the value
        $adjustmentType = '';
        if ($_REQUEST['adjustmentType'] == '-')
            $adjustmentType = $_REQUEST['adjustmentType'];

        $adjustment = $_REQUEST['adjustment'];
        $updatequery .= " adjustment=?,";
        array_push($updateparams, $adjustmentType . $adjustment);

        $total = $_REQUEST['total'];
        $updatequery .= " total=?";
        array_push($updateparams, $total);

        //$id_array = Array('PurchaseOrder'=>'purchaseorderid','SalesOrder'=>'salesorderid','Quotes'=>'quoteid','Invoice'=>'invoiceid');
        //Added where condition to which entity we want to update these values
        $updatequery .= " where " . $focus->table_index . "=?";
        array_push($updateparams, $focus->id);

        $adb->pquery($updatequery, $updateparams);

        //to save the S&H tax details in vtiger_inventoryshippingrel table
        $sh_tax_details = getAllTaxes('all', 'sh');
        $sh_query_fields = "id,";
        $sh_query_values = "?,";
        $sh_query_params = array($focus->id);
        for ($i = 0; $i < count($sh_tax_details); $i++) {
            $tax_name = $sh_tax_details[$i]['taxname'] . "_sh_percent";
            if ($_REQUEST[$tax_name] != '') {
                $sh_query_fields .= $sh_tax_details[$i]['taxname'] . ",";
                $sh_query_values .= "?,";
                array_push($sh_query_params, $_REQUEST[$tax_name]);
            }
        }
        $sh_query_fields = trim($sh_query_fields, ',');
        $sh_query_values = trim($sh_query_values, ',');

        $sh_query = "insert into vtiger_inventoryshippingrel($sh_query_fields) values($sh_query_values)";
        $adb->pquery($sh_query, $sh_query_params);
    }

    public static function getAssociatedProducts($module, $focus, $seid = '') {

        global $log;
        $log->debug("Entering getAssociatedProducts(" . $module . "," . get_class($focus) . "," . $seid . "='') method ...");
        global $adb;
        $output = '';
        global $theme, $current_user;

        $no_of_decimal_places = getCurrencyDecimalPlaces();
        $theme_path = "themes/" . $theme . "/";
        $image_path = $theme_path . "images/";
        $product_Detail = Array();

        // DG 15 Aug 2006
        // Add "ORDER BY sequence_no" to retain add order on all inventoryproductrel items

        $query = "select case when vtiger_products.productid != '' then vtiger_products.productname else vtiger_service.servicename end as productname," .
                " case when vtiger_products.productid != '' then 'Products' else 'Services' end as entitytype," .
                " case when vtiger_products.productid != '' then vtiger_products.unit_price else vtiger_service.unit_price end as unit_price," .
                " case when vtiger_products.productid != '' then vtiger_products.product_no else vtiger_service.service_no end as product_no," .
                " case when vtiger_products.productid != '' then vtiger_products.qtyinstock else 'NA' end as qtyinstock, vtiger_inventoryproductrel.*,vtiger_crmentity.deleted " .
                " from vtiger_inventoryproductrel" .
                " LEFT JOIN vtiger_crmentity ON vtiger_crmentity.crmid=vtiger_inventoryproductrel.productid" .
                " left join vtiger_products on vtiger_products.productid=vtiger_inventoryproductrel.productid " .
                " left join vtiger_service on vtiger_service.serviceid=vtiger_inventoryproductrel.productid " .
                " where id=? ORDER BY sequence_no";
        $params = array($focus->id);
        
        $historized = 0;
        $hist_res = $adb->pquery("SELECT * FROM vtiger_crmentity WHERE crmid=?", $params);
        $CData = $adb->fetchByAssoc($hist_res, 0);
		if (isset($CData["historized"]) && $CData["historized"] == "1") {
            $historized = $CData["historized"];
        }
        
        $result = $adb->pquery($query, $params);
        $num_rows = $adb->num_rows($result);
        for ($i = 1; $i <= $num_rows; $i++) {
            $deleted = $adb->query_result($result, $i - 1, 'deleted');
            $hdnProductId = $adb->query_result($result, $i - 1, 'productid');
            $hdnProductcode = $adb->query_result($result, $i - 1, 'productcode');
            if( $historized == 1 )
            {
                $referenceEntityType = getSalesEntityType($hdnProductId);
                $productFieldId = '';

                if (!empty($referenceEntityType)) {
                    $fieldResult = $adb->pquery(
                        'SELECT fieldid FROM vtiger_field WHERE tablename=(SELECT tablename FROM vtiger_entityname WHERE modulename=?) AND columnname=(SELECT fieldname FROM vtiger_entityname WHERE modulename=?)',
                        array($referenceEntityType, $referenceEntityType)
                    );
                    $productFieldId = $adb->query_result($fieldResult, 0, 'fieldid');
                }

                $params[1] = $hdnProductId;
                $params[2] = $productFieldId;
                $hist_res = $adb->pquery("SELECT label FROM its4you_historized WHERE crmid=? AND relid=? AND field_id=?", $params);
                $productname = $adb->query_result($hist_res,0,'label');
            }
            else
            {
                $productname=$adb->query_result($result,$i-1,'productname');
            }
            $productdescription = $adb->query_result($result, $i - 1, 'product_description');
            $comment = $adb->query_result($result, $i - 1, 'comment');
            $qtyinstock = $adb->query_result($result, $i - 1, 'qtyinstock');
            $qty = $adb->query_result($result, $i - 1, 'quantity');
            $unitprice = $adb->query_result($result, $i - 1, 'unit_price');
            $listprice = $adb->query_result($result, $i - 1, 'listprice');
            $entitytype = $adb->query_result($result, $i - 1, 'entitytype');

            if (($deleted) || (!isset($deleted))) {
                $product_Detail[$i]['productDeleted' . $i] = true;
            } elseif (!$deleted) {
                $product_Detail[$i]['productDeleted' . $i] = false;
            }

            if (!empty($entitytype)) {
                $product_Detail[$i]['entityType' . $i] = $entitytype;
            }

            if ($listprice == '')
                $listprice = $unitprice;
            if ($qty == '')
                $qty = 1;

            //calculate productTotal
            $productTotal = $qty * $listprice;

            //Delete link in First column
            if ($i != 1) {
                $product_Detail[$i]['delRow' . $i] = "Del";
            }
            if (empty($focus->mode) && $seid != '') {
                $sub_prod_query = $adb->pquery("SELECT crmid as prod_id from vtiger_seproductsrel WHERE productid=? AND setype='Products'", array($seid));
            } else {
                $sub_prod_query = $adb->pquery("SELECT productid as prod_id from vtiger_inventorysubproductrel WHERE id=? AND sequence_no=?", array($focus->id, $i));
            }
            $subprodid_str = '';
            $subprodname_str = '';
            $subProductArray = array();
            if ($adb->num_rows($sub_prod_query) > 0) {
                for ($j = 0; $j < $adb->num_rows($sub_prod_query); $j++) {
                    $sprod_id = $adb->query_result($sub_prod_query, $j, 'prod_id');
                    $sprod_name = $subProductArray[] = getProductName($sprod_id);
                    $str_sep = "";
                    if ($j > 0)
                        $str_sep = ":";
                    $subprodid_str .= $str_sep . $sprod_id;
                    $subprodname_str .= $str_sep . " - " . $sprod_name;
                }
            }

            $subprodname_str = str_replace(":", "<br>", $subprodname_str);

            $product_Detail[$i]['subProductArray' . $i] = $subProductArray;
            $product_Detail[$i]['hdnProductId' . $i] = $hdnProductId;
            $product_Detail[$i]['productName' . $i] = from_html($productname);
            /* Added to fix the issue Product Pop-up name display */
            if ($_REQUEST['action'] == 'CreateSOPDF' || $_REQUEST['action'] == 'CreatePDF' || $_REQUEST['action'] == 'SendPDFMail')
                $product_Detail[$i]['productName' . $i] = htmlspecialchars($product_Detail[$i]['productName' . $i]);
            $product_Detail[$i]['hdnProductcode' . $i] = $hdnProductcode;
            $product_Detail[$i]['productDescription' . $i] = from_html($productdescription);
            if ($module == 'Potentials' || $module == 'Products' || $module == 'Services') {
                $product_Detail[$i]['comment' . $i] = decode_html($productdescription);
            } else {
                $product_Detail[$i]['comment' . $i] = decode_html($comment);
            }

            if ($module != 'PurchaseOrder' && $focus->object_name != 'Order') {
                $product_Detail[$i]['qtyInStock' . $i] = decimalFormat($qtyinstock);
            }
            $listprice = number_format($listprice, $no_of_decimal_places, '.', '');
            $product_Detail[$i]['qty' . $i] = decimalFormat($qty);
            $product_Detail[$i]['listPrice' . $i] = $listprice;
            $product_Detail[$i]['unitPrice' . $i] = number_format($unitprice, $no_of_decimal_places, '.', '');
            $product_Detail[$i]['productTotal' . $i] = $productTotal;
            $product_Detail[$i]['subproduct_ids' . $i] = $subprodid_str;
            $product_Detail[$i]['subprod_names' . $i] = $subprodname_str;
            $discount_percent = decimalFormat($adb->query_result($result, $i - 1, 'discount_percent'));
            $discount_amount = (float)$adb->query_result($result, $i - 1, 'discount_amount');
            $discount_amount = decimalFormat(number_format($discount_amount, $no_of_decimal_places, '.', ''));
            $discountTotal = 0;
            //Based on the discount percent or amount we will show the discount details
            //To avoid NaN javascript error, here we assign 0 initially to' %of price' and 'Direct Price reduction'(for Each Product)
            $product_Detail[$i]['discount_percent' . $i] = 0;
            $product_Detail[$i]['discount_amount' . $i] = 0;

            if (!empty($discount_percent)) {
                $product_Detail[$i]['discount_type' . $i] = "percentage";
                $product_Detail[$i]['discount_percent' . $i] = $discount_percent;
                $product_Detail[$i]['checked_discount_percent' . $i] = ' checked';
                $product_Detail[$i]['style_discount_percent' . $i] = ' style="visibility:visible"';
                $product_Detail[$i]['style_discount_amount' . $i] = ' style="visibility:hidden"';
                $discountTotal = $productTotal * $discount_percent / 100;
            } elseif (!empty($discount_amount)) {
                $product_Detail[$i]['discount_type' . $i] = "amount";
                $product_Detail[$i]['discount_amount' . $i] = $discount_amount;
                $product_Detail[$i]['checked_discount_amount' . $i] = ' checked';
                $product_Detail[$i]['style_discount_amount' . $i] = ' style="visibility:visible"';
                $product_Detail[$i]['style_discount_percent' . $i] = ' style="visibility:hidden"';
                $discountTotal = $discount_amount;
            } else {
                $product_Detail[$i]['checked_discount_zero' . $i] = ' checked';
            }

            $totalAfterDiscount = $productTotal - $discountTotal;
            $product_Detail[$i]['discountTotal' . $i] = number_format($discountTotal, $no_of_decimal_places, '.', '');
            $product_Detail[$i]['totalAfterDiscount' . $i] = number_format($totalAfterDiscount, $no_of_decimal_places, '.', '');
            $taxTotal = 0;
            $product_Detail[$i]['taxTotal' . $i] = number_format($taxTotal, $no_of_decimal_places, '.', '');

            //Calculate netprice
            $netPrice = $totalAfterDiscount + $taxTotal;
            //if condition is added to call this function when we create Credit Note from Product module
            $taxtype = self::getInventoryTaxType($module, $focus->id);
            if ($taxtype == 'individual') {
                //Add the tax with product total and assign to netprice
                $netPrice = $netPrice + $taxTotal;
            }
            $product_Detail[$i]['netPrice' . $i] = $netPrice;

            //First we will get all associated taxes as array
            $tax_details = getTaxDetailsForProduct($hdnProductId, 'all');

            //Now retrieve the tax values from the current query with the name
            for ($tax_count = 0; $tax_count < count($tax_details); $tax_count++) {
                $tax_name = $tax_details[$tax_count]['taxname'];
                $tax_label = $tax_details[$tax_count]['taxlabel'];
                $tax_value = 0;

                //condition to avoid this function call when create new PO/SO/Quotes/Invoice from Product module
                if ($focus->id != '') {
                    if ($taxtype == 'individual')//if individual then show the entered tax percentage
                        $tax_value = getInventoryProductTaxValue($focus->id, $hdnProductId, $tax_name);
                    else//if group tax then we have to show the default value when change to individual tax
                        $tax_value = $tax_details[$tax_count]['percentage'];
                } else//if the above function not called then assign the default associated value of the product
                    $tax_value = $tax_details[$tax_count]['percentage'];

                $product_Detail[$i]['taxes'][$tax_count]['taxname'] = $tax_name;
                $product_Detail[$i]['taxes'][$tax_count]['taxlabel'] = $tax_label;
                $product_Detail[$i]['taxes'][$tax_count]['percentage'] = $tax_value;
            }
        }

        //set the taxtype
        $product_Detail[1]['final_details']['taxtype'] = $taxtype;

        //Get the Final Discount, S&H charge, Tax for S&H and Adjustment values
        //To set the Final Discount details
        $finalDiscount = 0;
        $product_Detail[1]['final_details']['discount_type_final'] = 'zero';
        $subTotal = (float)$focus->column_fields['hdnSubTotal'];
        $product_Detail[1]['final_details']['hdnSubTotal'] = number_format($subTotal, $no_of_decimal_places, '.', '');
        $discountPercent = (float)$focus->column_fields['hdnDiscountPercent'];
        $discountAmount = (float)$focus->column_fields['hdnDiscountAmount'];

        if (!empty($discountPercent)) {
            $discountAmount = ($product_Detail[1]['final_details']['hdnSubTotal'] * $discountPercent / 100);
        }

        //To avoid NaN javascript error, here we assign 0 initially to' %of price' and 'Direct Price reduction'(For Final Discount)
        $product_Detail[1]['final_details']['discount_percentage_final'] = 0;
        $product_Detail[1]['final_details']['discount_amount_final'] = number_format(0, $no_of_decimal_places, '.', '');

        if (!empty($focus->column_fields['hdnDiscountPercent'])) {
            $finalDiscount = ($subTotal * $discountPercent / 100);
            $product_Detail[1]['final_details']['discount_type_final'] = 'percentage';
            $product_Detail[1]['final_details']['discount_percentage_final'] = $discountPercent;
            $product_Detail[1]['final_details']['checked_discount_percentage_final'] = ' checked';
            $product_Detail[1]['final_details']['style_discount_percentage_final'] = ' style="visibility:visible"';
            $product_Detail[1]['final_details']['style_discount_amount_final'] = ' style="visibility:hidden"';
        } elseif (!empty($focus->column_fields['hdnDiscountAmount'])) {
            $finalDiscount = $focus->column_fields['hdnDiscountAmount'];
            $product_Detail[1]['final_details']['discount_type_final'] = 'amount';
            $product_Detail[1]['final_details']['discount_amount_final'] = $discountAmount;
            $product_Detail[1]['final_details']['checked_discount_amount_final'] = ' checked';
            $product_Detail[1]['final_details']['style_discount_amount_final'] = ' style="visibility:visible"';
            $product_Detail[1]['final_details']['style_discount_percentage_final'] = ' style="visibility:hidden"';
        }

        $finalDiscount = number_format((float)$finalDiscount, $no_of_decimal_places, '.', '');
        $product_Detail[1]['final_details']['discountTotal_final'] = $finalDiscount;

        //To set the Final Tax values
        //we will get all taxes. if individual then show the product related taxes only else show all taxes
        //suppose user want to change individual to group or vice versa in edit time the we have to show all taxes. so that here we will store all the taxes and based on need we will show the corresponding taxes

        $taxTotal = 0;
        //First we should get all available taxes and then retrieve the corresponding tax values
        $tax_details = getAllTaxes('available', '', 'edit', $focus->id);

        for ($tax_count = 0; $tax_count < count($tax_details); $tax_count++) {
            $tax_name = $tax_details[$tax_count]['taxname'];
            $tax_label = $tax_details[$tax_count]['taxlabel'];

            //if taxtype is individual and want to change to group during edit time then we have to show the all available taxes and their default values
            //Also taxtype is group and want to change to individual during edit time then we have to provide the asspciated taxes and their default tax values for individual products
            if ($taxtype == 'group') {
                $tax_percent = (float)$adb->query_result($result, 0, $tax_name);
            } else {
                $tax_percent = (float)$tax_details[$tax_count]['percentage'];
            }

            $taxAmount = ($subTotal - $finalDiscount) * $tax_percent / 100;
            $taxTotal = $taxTotal + $taxAmount;
            $product_Detail[1]['final_details']['taxes'][$tax_count]['taxname'] = $tax_name;
            $product_Detail[1]['final_details']['taxes'][$tax_count]['taxlabel'] = $tax_label;
            $product_Detail[1]['final_details']['taxes'][$tax_count]['percentage'] = $tax_percent;
            $product_Detail[1]['final_details']['taxes'][$tax_count]['amount'] = number_format($taxAmount, $no_of_decimal_places, '.', '');
        }

        $product_Detail[1]['final_details']['tax_totalamount'] = $taxTotal;

        //To set the Shipping & Handling charge
        $shCharge = (float)$focus->column_fields['hdnS_H_Amount'];
        $product_Detail[1]['final_details']['shipping_handling_charge'] = number_format($shCharge, $no_of_decimal_places, '.', '');

        //To set the Shipping & Handling tax values
        //calculate S&H tax
        $shtaxtotal = 0;
        //First we should get all available taxes and then retrieve the corresponding tax values
        $shtax_details = getAllTaxes('available', 'sh', 'edit', $focus->id);

        //if taxtype is group then the tax should be same for all products in vtiger_inventoryproductrel table
        for ($shtax_count = 0; $shtax_count < count($shtax_details); $shtax_count++) {
            $shtax_name = $shtax_details[$shtax_count]['taxname'];
            $shtax_label = $shtax_details[$shtax_count]['taxlabel'];
            //if condition is added to call this function when we create PO/SO/Quotes/Invoice from Product module
            $shtax_percent = self::getInventorySHTaxPercent($focus->id, $shtax_name);
            $shtaxamount = $shCharge * $shtax_percent / 100;
            $shtaxtotal = $shtaxtotal + $shtaxamount;
            $product_Detail[1]['final_details']['sh_taxes'][$shtax_count]['taxname'] = $shtax_name;
            $product_Detail[1]['final_details']['sh_taxes'][$shtax_count]['taxlabel'] = $shtax_label;
            $product_Detail[1]['final_details']['sh_taxes'][$shtax_count]['percentage'] = $shtax_percent;
            $product_Detail[1]['final_details']['sh_taxes'][$shtax_count]['amount'] = $shtaxamount;
        }

        $product_Detail[1]['final_details']['shtax_totalamount'] = number_format($shtaxtotal, $no_of_decimal_places, '.', '');

        //To set the Adjustment value
        $adjustment = (float)$focus->column_fields['txtAdjustment'];
        $product_Detail[1]['final_details']['adjustment'] = number_format($adjustment, $no_of_decimal_places, '.', '');

        //To set the grand total
        $grandTotal = (float)$focus->column_fields['hdnGrandTotal'];
        $product_Detail[1]['final_details']['grandTotal'] = number_format($grandTotal, $no_of_decimal_places, '.', '');

        $log->debug("Exiting getAssociatedProducts method ...");

        return $product_Detail;
    }

    /** 	function used to get the price type for the entity (PO, SO, Quotes or Invoice)
     * 	@param string $module - module name
     * 	@param int $id - id of the PO or SO or Quotes or Invoice
     * 	@return string $pricetype - pricetype for the given entity which will be unitprice or secondprice
     */
    public static function getInventoryCurrencyInfo($module, $id) {
        global $adb;
        $inv_table_array = Array('PurchaseOrder' => 'vtiger_purchaseorder', 'SalesOrder' => 'vtiger_salesorder', 'Quotes' => 'vtiger_quotes', 'Invoice' => 'vtiger_invoice', 'CreditNotes4You' => 'vtiger_creditnotes4you');
        $inv_id_array = Array('PurchaseOrder' => 'purchaseorderid', 'SalesOrder' => 'salesorderid', 'Quotes' => 'quoteid', 'Invoice' => 'invoiceid', 'CreditNotes4You' => 'creditnotes4you_id');
        $inventory_table = $inv_table_array[$module];
        $inventory_id = $inv_id_array[$module];
        $res = $adb->pquery("select currency_id, $inventory_table.conversion_rate as conv_rate, vtiger_currency_info.* from $inventory_table
						inner join vtiger_currency_info on $inventory_table.currency_id = vtiger_currency_info.id
						where $inventory_id=?", array($id));
        $currency_info = array();
        $currency_info['currency_id'] = $adb->query_result($res, 0, 'currency_id');
        $currency_info['conversion_rate'] = $adb->query_result($res, 0, 'conv_rate');
        $currency_info['currency_name'] = $adb->query_result($res, 0, 'currency_name');
        $currency_info['currency_code'] = $adb->query_result($res, 0, 'currency_code');
        $currency_info['currency_symbol'] = $adb->query_result($res, 0, 'currency_symbol');
        return $currency_info;
    }

    /** function used to get the tax type for the entity (PO, SO, Quotes or Invoice)
     * 	@param string $module - module name
     * 	@param int $id - id of the Credit Note
     * 	@return string $taxtype - taxtype for the given entity which will be individual or group
     */
    private static function getInventoryTaxType($module, $id) {
        global $log, $adb;
        $log->debug("Entering into function getInventoryTaxType($module, $id).");
        $res = $adb->pquery("select taxtype from vtiger_creditnotes4you where creditnotes4you_id=?", array($id));
        $taxtype = $adb->query_result($res, 0, 'taxtype');
        $log->debug("Exit from function getInventoryTaxType($module, $id).");
        return $taxtype;
    }

    /** function used to get the shipping & handling tax percentage for the given inventory id and taxname
     * 	@param int $id - entity id which will be Credit Note id
     * 	@param string $taxname - shipping and handling taxname
     * 	@return float $taxpercentage - shipping and handling taxpercentage which is associated with the given entity
     */
    private static function getInventorySHTaxPercent($id, $taxname) {
        global $log, $adb;
        $log->debug("Entering into function getInventorySHTaxPercent($id, $taxname)");
        $res = $adb->pquery("select $taxname from vtiger_inventoryshippingrel where id= ?", array($id));
        $taxpercentage = $adb->query_result($res, 0, $taxname);
        if ($taxpercentage == '')
            $taxpercentage = 0;
        $log->debug("Exit from function getInventorySHTaxPercent($id, $taxname)");
        return $taxpercentage;
    }

}
