<?php

/* * *******************************************************************************
 * The content of this file is subject to the CreditNotes4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

include_once 'include/InventoryPDFController.php';

class Vtiger_CreditNotes4YouPDFController extends Vtiger_InventoryPDFController {

    function buildHeaderModelTitle() {
        $singularModuleNameKey = 'SINGLE_' . $this->moduleName;
        $translatedSingularModuleLabel = getTranslatedString($singularModuleNameKey, $this->moduleName);
        if ($translatedSingularModuleLabel == $singularModuleNameKey) {
            $translatedSingularModuleLabel = getTranslatedString($this->moduleName, $this->moduleName);
        }
        return sprintf("%s: %s", $translatedSingularModuleLabel, $this->focusColumnValue('creditnotes4you_no'));
    }

    function buildHeaderModelColumnCenter() {
        $customerName = $this->resolveReferenceLabel($this->focusColumnValue('account_id'), 'Accounts');
        $contactName = $this->resolveReferenceLabel($this->focusColumnValue('contact_id'), 'Contacts');
        $purchaseOrder = $this->focusColumnValue('vtiger_purchaseorder');
        $salesOrder = $this->resolveReferenceLabel($this->focusColumnValue('salesorder_id'));

        $customerNameLabel = getTranslatedString('Customer Name', $this->moduleName);
        $contactNameLabel = getTranslatedString('Contact Name', $this->moduleName);
        $purchaseOrderLabel = getTranslatedString('Purchase Order', $this->moduleName);
        $salesOrderLabel = getTranslatedString('Sales Order', $this->moduleName);

        $modelColumnCenter = array(
            $customerNameLabel => $customerName,
            $purchaseOrderLabel => $purchaseOrder,
            $contactNameLabel => $contactName,
            $salesOrderLabel => $salesOrder
        );
        return $modelColumnCenter;
    }

    function buildHeaderModelColumnRight() {
        $issueDateLabel = getTranslatedString('Issued Date', $this->moduleName);
        $validDateLabel = getTranslatedString('Due Date', $this->moduleName);
        $billingAddressLabel = getTranslatedString('Billing Address', $this->moduleName);
        $shippingAddressLabel = getTranslatedString('Shipping Address', $this->moduleName);

        $modelColumnRight = array(
            'dates' => array(
                $issueDateLabel => $this->formatDate(date("Y-m-d")),
                $validDateLabel => $this->formatDate($this->focusColumnValue('duedate')),
            ),
            $billingAddressLabel => $this->buildHeaderBillingAddress(),
            $shippingAddressLabel => $this->buildHeaderShippingAddress()
        );
        return $modelColumnRight;
    }

    function getWatermarkContent() {
        return $this->focusColumnValue('creditnotes4youstatus');
    }

    function loadRecord($id) {
        global $current_user;
        $this->focus = $focus = CRMEntity::getInstance($this->moduleName);
        $focus->retrieve_entity_info($id, $this->moduleName);
        $focus->apply_field_security();
        $focus->id = $id;
        $this->associated_products = CreditNotes4You_Inventory_Helper::getAssociatedProducts($this->moduleName, $focus);
    }

}

?>
