<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
 
function Invoice_sendInvoicesToQoyod($entity) {
    // echo "<pre>"; print_r($entity); exit;
	
	$invoice_id = $entity->get('id');
    $invoice = explode('x', $invoice_id);
    $invoiceId = $invoice[1];
    
    $description = (empty($entity->get('description')))? $entity->get('subject') : $entity->get('description');
    $invoicedate = $entity->get('invoicedate');
    $invoicestatus = $entity->get('invoicestatus');
    $duedate = $entity->get('duedate');
    $contact_id = $entity->get('contact_id');
    $contact = explode('x', $contact_id);
    $contactId = $contact[1];
    $suppplydate = $entity->get('cf_1435');
    
    // ✅ Get Qoyod contact ID from Contacts
    $contactRecord = Vtiger_Record_Model::getInstanceById($contactId, "Contacts");
    $qoyod_contact_id = $contactRecord->get('cf_1397');
    
    // ✅ Prepare line items
    $LineItems = $entity->get('LineItems');
    $inventory = [];
    $i = 0;
    
    foreach ($LineItems as $val) {
        $product_id = explode('x', $val['productid']);
        $productId = $product_id[1];
        $productRecord = Vtiger_Record_Model::getInstanceById($productId, "Products");
        $prod_desc = ($val['description'])? $val['description']:"";
        $inventory[] = [
            "product_id"    => (int)$productRecord->get('cf_1428'),  // Qoyod product ID
            "description"   => $prod_desc,
            "quantity"      => (float)$val['quantity'],
            "unit_price"    => (float)$val['listprice'],
            "discount"      => (float)$val['discount_amount'],
            "discount_type" => "amount",
            "tax_percent"   => (float)$val['tax1']
        ];
    }
    
    $data = [
        "invoice" => [
            "contact_id"   => $qoyod_contact_id,
            "reference"    => "api-inv-$invoiceId",
            "description"  => $description,
            "issue_date"   => $invoicedate,
            "due_date"     => $duedate,
            "supply_date"  => $suppplydate,
            "status"       => "Draft",
            "inventory_id" => 1,
            "line_items"   => $inventory
        ]
    ];
    // echo "<pre>"; print_r($data); exit;
    $jsonData = json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    // echo $jsonData; exit;

	// Replace with your Qoyod API token
	$apiKey = "6eb51ba093a56f0f0c00ea6dd";

	$curl = curl_init();

	curl_setopt_array($curl, array(
	CURLOPT_URL => 'https://www.qoyod.com/api/2.0/invoices',
	CURLOPT_RETURNTRANSFER => true,
	CURLOPT_ENCODING => '',
	CURLOPT_MAXREDIRS => 10,
	CURLOPT_TIMEOUT => 0,
	CURLOPT_FOLLOWLOCATION => true,
	CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	CURLOPT_CUSTOMREQUEST => 'POST',
	CURLOPT_POSTFIELDS => $jsonData,
	CURLOPT_HTTPHEADER => array(
		'API-KEY: '.$apiKey,
		'Content-Type: application/json'
	),
	));

	$response = curl_exec($curl);
// 	echo "<pre>"; print_r($response); exit;
	if (curl_errno($curl)) {
        echo "❌ cURL error: " . curl_error($curl);  exit;
    }

	curl_close($curl);

}

function handleInventoryProductRel($entity){
	require_once("include/utils/InventoryUtils.php");
	updateInventoryProductRel($entity);
}

?>
