<?php
/**
 * Update Vtiger Contact Field using Qoyod API + Direct MySQL Query
 */

// === Qoyod API Setup ===
$qoyod_api_key = "6eb51ba093a56f0f0c00ea6dd"; // Replace with your key
$qoyod_api_url = "https://www.qoyod.com/api/2.0/products";

// --- Vtiger DB Connection (from your config) ---
$db_host = 'localhost';
$db_port = '3306';
$db_user = 'vtiger';
$db_pass = 'ZAin$2020';
$db_name = 'vtiger';

// --- Connect to database ---
$conn = new mysqli($db_host, $db_user, $db_pass, $db_name, $db_port);
if ($conn->connect_error) {
    die("❌ Database connection failed: " . $conn->connect_error);
}
echo "✅ Connected to Vtiger database.\n";

// === 1️⃣ Get Customers from Qoyod ===
$ch = curl_init();
curl_setopt_array($ch, [
  CURLOPT_URL => $qoyod_api_url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => ['API-KEY: ' . $qoyod_api_key],
]);
$response = curl_exec($ch);
curl_close($ch);

$qoyod = json_decode($response, true);

// echo "<pre>"; print_r($qoyod); exit;

if (!isset($qoyod['products'])) {
    die("❌ Failed to fetch Qoyod product. Response: " . $response);
}

$products = $qoyod['products'];
echo "📦 Found " . count($products) . " products from Qoyod.\n";
// exit;


// === 3️⃣ Loop through Qoyod Customers and Update Field ===
$updated = 0;

foreach ($products as $prod) {
    $qoyod_id = trim($prod['id'] ?? '');
    $sku = trim($prod['sku'] ?? '');
    
    if ($qoyod_id == '') continue;
    
    $stmt = $conn->prepare("UPDATE vtiger_productcf 
        SET cf_1428 = ? 
        WHERE cf_1131 = ?");
    
    
    if (!$stmt) {
        echo "❌ Prepare failed: " . $conn->error . "\n";
        continue;
    }
    
    $stmt->bind_param("ss", $qoyod_id, $sku);
    $stmt->execute();
    
    if ($stmt->error) {
        echo "❌ Query error: " . $stmt->error . "\n";
    } elseif ($stmt->affected_rows > 0) {
        echo "✅ Updated product: {$sku}\n";
    } else {
        echo "⚠️ No match or already has cf_1427 for {$sku}\n";
    }

}

$conn->close();
echo "🎯 Done. Updated {$updated} records.\n";

echo "<pre>"; print_r($products);