<?php
/**
 * Update Vtiger Contact Field using Qoyod API + Direct MySQL Query
 */

// === Qoyod API Setup ===
$qoyod_api_key = "6eb51ba093a56f0f0c00ea6dd"; // Replace with your key
$qoyod_api_url = "https://www.qoyod.com/api/2.0/customers?page=1";

// --- Vtiger DB Connection (from your config) ---
$db_host = 'localhost';
$db_port = '3306';
$db_user = 'vtiger';
$db_pass = 'ZAin$2020';
$db_name = 'vtiger';

// --- Connect to database ---
$conn = new mysqli($db_host, $db_user, $db_pass, $db_name, $db_port);
if ($conn->connect_error) {
    die("❌ Database connection failed: " . $conn->connect_error);
}
echo "✅ Connected to Vtiger database.\n";

// === 1️⃣ Get Customers from Qoyod ===
$ch = curl_init();
curl_setopt_array($ch, [
  CURLOPT_URL => $qoyod_api_url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => ['API-KEY: ' . $qoyod_api_key],
]);
$response = curl_exec($ch);
curl_close($ch);

$qoyod = json_decode($response, true);

if (!isset($qoyod['customers'])) {
    die("❌ Failed to fetch Qoyod customers. Response: " . $response);
}

$customers = $qoyod['customers'];
echo "📦 Found " . count($customers) . " customers from Qoyod.\n";

// === 3️⃣ Loop through Qoyod Customers and Update Field ===
$updated = 0;

foreach ($customers as $cust) {
    $qoyod_id = trim($cust['id'] ?? '');
    $phone = trim($cust['phone_number'] ?? '');
    
    if ($phone == '' || $qoyod_id == '') continue;
    
    $stmt = $conn->prepare("
        UPDATE vtiger_contactdetails 
        SET cf_1397 = ? 
        WHERE mobile = ? AND (cf_1397 IS NULL OR cf_1397 = '')
    ");
    
    if (!$stmt) {
        echo "❌ Prepare failed: " . $conn->error . "\n";
        continue;
    }
    
    $stmt->bind_param("ss", $qoyod_id, $phone);
    $stmt->execute();
    
    // echo "UPDATE vtiger_contactdetails 
    //     SET cf_1397 = '".$qoyod_id."' 
    //     WHERE phone = '".$phone."' AND (cf_1397 IS NULL OR cf_1397 = '')";
    
    if ($stmt->error) {
        echo "❌ {$phone} Query error: {$stmt->error}\n";
    } elseif ($stmt->affected_rows > 0) {
        echo "✅ Updated contact {$phone}\n";
    } else {
        echo "⚠️ No change for {$phone}\n";
    }
}

$conn->close();
echo "🎯 Done. Updated {$updated} records.\n";

echo "<pre>"; print_r($customers);