<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

require_once 'modules/ITS4YouImport/libraries/PHPExcel.php';

class ITS4YouImport_PHPExcelWriter_Writer extends ITS4YouImport_FileWriter_Writer
{

    /** @var PHPExcel */
    protected $phpExcel;

    protected function __construct($fileName)
    {
        parent::__construct($fileName);

        $this->phpExcel = new PHPExcel();
        $this->phpExcel->setActiveSheetIndex(0);
    }

    public function __destruct()
    {
        $this->phpExcel->disconnectWorksheets();
        unset($this->phpExcel);
    }

    protected function getExportContentType()
    {
        throw new Exception("Imports4You :: Implementation must be overriden");
    }

    protected function getOutputFileName()
    {
        throw new Exception("Imports4You :: Implementation must be overriden");
    }

    protected function outputData($entries)
    {
        $workSheet = $this->phpExcel->getActiveSheet();
        $rowIdx = 2;
        foreach ($entries as $entry) {
            $columnIdx = 0;
            foreach ($entry as $entryVal) {
                $workSheet->setCellValueByColumnAndRow($columnIdx, $rowIdx, $entryVal);
                //assumption is that first two columns contain information about line_number and log_message
                if ($columnIdx < 2) {
                    $workSheet->getStyleByColumnAndRow($columnIdx, $rowIdx)->getFont()->setItalic(true);
                    $workSheet->getStyleByColumnAndRow($columnIdx, $rowIdx)
                        ->getFill()
                        ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                        ->getStartColor()
                        ->setRGB('FFD6D6');
                }

                $columnIdx++;
            }
            $rowIdx++;
        }
    }

    protected function outputHeader($headers)
    {
        $workSheet = $this->phpExcel->getActiveSheet();
        /* @var $workSheet PHPExcel_Worksheet */
        $columnIdx = 0;
        foreach ($headers as $header) {
            $workSheet->setCellValueByColumnAndRow($columnIdx, 1, $header);
            $workSheet->getColumnDimensionByColumn($columnIdx)->setAutoSize(true);

            $workSheet->getStyleByColumnAndRow($columnIdx, 1)->getFont()->setBold(true);
            $workSheet->getStyleByColumnAndRow($columnIdx, 1)
                ->getFill()
                ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                ->getStartColor()
                ->setRGB('F5F5F5');
            $columnIdx++;
        }
    }

}
