<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouImport_Map_Model extends Import_Map_Model
{

    public static function getAllByModule($moduleName)
    {
        global $current_user;
        $db = PearDatabase::getInstance();

        $result = $db->pquery('SELECT * FROM ' . parent::$tableName . ' WHERE deleted=0 AND module=?', array($moduleName));
        $noOfMaps = $db->num_rows($result);

        $savedMaps = array();
        for ($i = 0; $i < $noOfMaps; ++$i) {
            $importMap = ITS4YouImport_Map_Model::getInstanceFromDb($db->query_result_rowdata($result, $i), $current_user);
            $savedMaps[$importMap->getId()] = $importMap;
        }

        return $savedMaps;
    }

    public static function getInstanceFromDb($row, $user)
    {
        $map = array();
        foreach ($row as $key => $value) {
            if ($key == 'content') {
                $content = array();
                $pairs = explode("&", html_entity_decode($value));
                foreach ($pairs as $pair) {
                    list($mappedName, $sequence) = explode("=", $pair);
                    $content["$mappedName"] = $sequence;
                }
                $map[$key] = $content;
            } else {
                $map[$key] = $value;
            }
        }
        return new Import_Map_Model($map, $user);
    }

}
