<?php
/* * *******************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouImport_Field_Model extends Vtiger_Field_Model
{

    public function getDisplayValue($value, $record = false, $recordInstance = false)
    {
        if ($this->getFieldName() != "merge_fields") {
            return parent::getDisplayValue($value, $record, $recordInstance);
        } else {
            $jsonDecoded = json_decode(html_entity_decode($value));
            if (!empty($jsonDecoded)) {
                return implode(", ", $jsonDecoded);
            } else {
                return "";
            }
        }
    }

    /**
     * @return array
     */
    public function getPicklistValues()
    {
        switch ($this->getName()) {
            case 'delimiter':
                return $this->getDelimiterValues();
        }

        return parent::getPicklistValues();
    }

    /**
     * @return array
     */
    public function getDelimiterValues()
    {
        return array(',', ';', '|', '^');
    }

    /**
     * @return array
     */
    public function getEditablePicklistValues()
    {
        switch ($this->getName()) {
            case 'delimiter':
                return $this->getDelimiterValues();
        }

        return parent::getEditablePicklistValues();
    }
}
