<?php
/* * *******************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouImport_Config_Model extends Import_Config_Model
{

    public function __construct()
    {
        parent::__construct();

        $its4youImportTypes = array(
            //standard
            'csv' => array('reader' => 'ITS4YouImport_CSVReader_Reader', 'classpath' => 'modules/ITS4YouImport/readers/CSVReader.php'),
            'vcf' => array('reader' => 'ITS4YouImport_VCardReader_Reader', 'classpath' => 'modules/ITS4YouImport/readers/VCardReader.php'),
            'default' => array('reader' => 'ITS4YouImport_FileReader_Reader', 'classpath' => 'modules/ITS4YouImport/readers/FileReader.php'),
            //'ics' => array('reader' => 'ITS4YouImport_ICSReader_Reader', 'classpath' => 'modules/ITS4YouImport/readers/ICSReader.php'),   //not used not needed
            //additional
            'xls' => array('reader' => 'ITS4YouImport_XLSReader_Reader', 'classpath' => 'modules/ITS4YouImport/readers/XLSReader.php'),
            'xlsx' => array('reader' => 'ITS4YouImport_XLSXReader_Reader', 'classpath' => 'modules/ITS4YouImport/readers/XLSXReader.php')
        );
        $this->set("importTypes", $its4youImportTypes);
        $this->set("userImportTablePrefix", "its4you_import");
        // Individual batch limit - Specified number of records will be imported at one shot and the cycle will repeat till all records are imported
        $this->set("importBatchLimit", '500');
        // Threshold record limit for immediate import. If record count is more than this, then the import is scheduled through cron job
        $this->set("immediateImportLimit", '15000');
    }

}
