<?php
/* * *******************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouImport_Utils_Helper extends Import_Utils_Helper
{

    public static function validateFileUpload($request)
    {
        $current_user = Users_Record_Model::getCurrentUserModel();
        $fileReader = self::getFileReader($request, $current_user);
        if ($fileReader == null) {
            $request->set('error_message', vtranslate('LBL_INVALID_FILE', 'Import'));
            return false;
        }

        $hasHeader = $fileReader->hasHeader();
        $firstRow = $fileReader->getFirstRowData($hasHeader);
        if ($firstRow === false) {
            $request->set('error_message', vtranslate('LBL_NO_ROWS_FOUND', 'Import'));
            return false;
        }

        $fileReader->hasHeader = $hasHeader;
        $fileReader->firstRowData = $firstRow;

        return $fileReader;
    }

    public static function getFileReader($request, $user)
    {
        $fileReaderInfo = self::getFileReaderInfo($request->get('type'));
        if (!empty($fileReaderInfo)) {
            require_once $fileReaderInfo['classpath'];
            $fileReader = new $fileReaderInfo['reader']($request, $user);
        } else {
            $fileReader = null;
        }
        return $fileReader;
    }

    public static function getFileReaderInfo($type)
    {
        $configReader = new ITS4YouImport_Config_Model();
        $importTypeConfig = $configReader->get('importTypes');
        if (isset($importTypeConfig[$type])) {
            return $importTypeConfig[$type];
        }

        return null;
    }

    public static function validateFileUploadAsync($request)
    {
        $current_user = Users_Record_Model::getCurrentUserModel();

        $uploadMaxSize = self::getMaxUploadSize();
        $importDirectory = self::getImportDirectory();
        $temporaryFileName = self::getImportFilePath($current_user);
        if ($_FILES['import_file']['error']) {
            $request->set('error_message', self::fileUploadErrorMessage($_FILES['import_file']['error']));
            return false;
        }
        if (!is_uploaded_file($_FILES['import_file']['tmp_name'])) {
            $request->set('error_message', vtranslate('LBL_FILE_UPLOAD_FAILED', 'Import'));
            return false;
        }
        //store the file name into request for further processing
        $request->set("filename", $_FILES['import_file']['name']);

        if ($_FILES['import_file']['size'] > $uploadMaxSize) {
            $request->set('error_message', vtranslate('LBL_IMPORT_ERROR_LARGE_FILE', 'Import') . $uploadMaxSize . ' ' . vtranslate('LBL_IMPORT_CHANGE_UPLOAD_SIZE', 'Import'));
            return false;
        }

        if (!is_writable($importDirectory)) {
            $request->set('error_message', vtranslate('LBL_IMPORT_DIRECTORY_NOT_WRITABLE', 'Import'));
            return false;
        }

        $fileCopied = move_uploaded_file($_FILES['import_file']['tmp_name'], $temporaryFileName);
        if (!$fileCopied) {
            $request->set('error_message', vtranslate('LBL_IMPORT_FILE_COPY_FAILED', 'Import'));
            return false;
        }
        //Commented lines are within the original method validateFileUpload
//        $fileReader = self::getFileReader($request, $current_user);
//        if ($fileReader == null) {
//            $request->set('error_message', vtranslate('LBL_INVALID_FILE', 'Import'));
//            return false;
//        }
//
//        $hasHeader = $fileReader->hasHeader();
//        $firstRow = $fileReader->getFirstRowData($hasHeader);
//        if ($firstRow === false) {
//            $request->set('error_message', vtranslate('LBL_NO_ROWS_FOUND', 'Import'));
//            return false;
//        }
        return true;
    }

    public static function getMaxUploadSize()
    {
        global $upload_maxsize;

        $post_max_size = self::getMaxPostSize();
        $upload_maxsize = min($post_max_size, $upload_maxsize);

        return $upload_maxsize;
    }

    public static function getMaxPostSize()
    {
        $val = ini_get('post_max_size');
        $val = trim($val);
        $last = strtolower($val[strlen($val) - 1]);
        switch ($last) {
            case 'g':
                $val *= 1024;
            case 'm':
                $val *= 1024;
            case 'k':
                $val *= 1024;
        }

        return $val;
    }

    public static function showImportLockedError($lockInfo)
    {
        $errorMessage = vtranslate('ERR_MODULE_IMPORT_LOCKED', 'ITS4YouImport');
        $errorDetails = array(
            vtranslate('LBL_MODULE_NAME', 'ITS4YouImport') => getTabModuleName($lockInfo['tabid']),
            vtranslate('LBL_USER_NAME', 'ITS4YouImport') => getUserFullName($lockInfo['userid']),
            vtranslate('LBL_LOCKED_TIME', 'ITS4YouImport') => $lockInfo['locked_since']
        );

        self::showErrorPage($errorMessage, $errorDetails);
    }

    public static function showErrorPage($errorMessage, $errorDetails = false, $customActions = false)
    {
        $viewer = new Vtiger_Viewer();
        $viewer->assign('ERROR_MESSAGE', $errorMessage);
        $viewer->assign('ERROR_DETAILS', $errorDetails);
        $viewer->assign('CUSTOM_ACTIONS', $customActions);
        $viewer->assign('MODULE', 'ITS4YouImport');
        $viewer->assign('STEP', '4');

        $viewer->view('ImportError.tpl', 'ITS4YouImport');
    }

    public static function showImportTableBlockedError($moduleName, $user)
    {
        $errorMessage = vtranslate('ERR_UNIMPORTED_RECORDS_EXIST', 'ITS4YouImport');
        $customActions = array('LBL_CLEAR_DATA' => "location.href='index.php?module=ITS4YouImport&targetModule{$moduleName}&view=Edit&mode=clearCorruptedData'");

        self::showErrorPage($errorMessage, '', $customActions);
    }

    public static function clearUserImportInfo($user)
    {
        $adb = PearDatabase::getInstance();
        $tableName = self::getDbTableName($user);

        $adb->query('DROP TABLE IF EXISTS ' . $tableName);
        ITS4YouImport_Lock_Action::unLock($user);
        ITS4YouImport_Queue_Action::removeForUser($user);
    }

    public static function getUnsupportedModulesForDuplicateHandling()
    {
        return self::getInventoryModules();
    }

    public static function getInventoryModules()
    {
        return getInventoryModules();
    }

    public static function getMergableFields($targetModuleMeta)
    {
        $mergableFields = $targetModuleMeta->getMergableFields();

        //since modifiedtime and modifiedby are not allowed to be used in step2
        //as import fields we need to remove them from $mergableFields
        unset($mergableFields["modifiedtime"]);
        unset($mergableFields["modifiedby"]);
        return $mergableFields;
    }

    public static function getCustomSupportedFileExtensions()
    {
        $standardFileExtensions = parent::getSupportedFileExtensions();

        return array_merge($standardFileExtensions, array("xls", "xlsx"));
    }

    public static $referenceSeparator = '__REFERENCE__';

    public static function getSearchFields($moduleName)
    {
        $searchFields = [];
        $referenceModules = self::getReferenceModules($moduleName);

        foreach ($referenceModules as $referenceModule) {
            if (in_array($referenceModule, ['Users', 'Currency'])) {
                continue;
            }

            $referenceModel = Vtiger_Module_Model::getInstance($referenceModule);

            foreach ($referenceModel->getFields() as $field) {
                $searchFields[] = [
                    'label' => vtranslate($referenceModule, $referenceModule) . ' ' . vtranslate($field->get('label'), $referenceModule),
                    'value' => $referenceModule . self::$referenceSeparator . $field->get('name'),
                ];
            }
        }

        return $searchFields;
    }

    public static function isReferenceField($fieldName)
    {
        return false !== stripos($fieldName, self::$referenceSeparator);
    }

    public static function getReferenceModules($moduleName)
    {
        $moduleModel = Vtiger_Module_Model::getInstance($moduleName);
        $referenceFields = $moduleModel->getFieldsByType('reference');
        $referenceModules = array();

        /** @var Vtiger_Field_Model $referenceField */
        foreach ($referenceFields as $referenceField) {
            foreach ($referenceField->getReferenceList() as $referenceModule) {
                $referenceModules[] = $referenceModule;
            }
        }

        return array_unique($referenceModules);
    }
}
