<?php
/* * *******************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouImport_DownloadFailed_Action extends Vtiger_Action_Controller
{

    public static $LOG_ENTRY_ID_KEY = "id";
    public static $LOG_MESSAGE_KEY = "log_message";
    private $targetModule;

    public function checkPermission(Vtiger_Request $request)
    {
        return true;
    }

    /**
     * Current version of process method which works with Logger instance
     * @param Vtiger_Request $request
     */
    public function process(Vtiger_Request $request)
    {
        $importId = $request->get("import_entity_id");
        $importRecordModel = Vtiger_Record_Model::getInstanceById($importId, "ITS4YouImport");
        $this->targetModule = $importRecordModel->get("target_module");
        $foruser = $importRecordModel->get('assigned_user_id');

        $logger = ITS4YouImport_Logger_Model::factory($importId, $foruser);
        /* @var $logEntry ITS4YouImport_LogEntryBase_Model */
        $logEntries = $logger->getLogEntries();
        if (!empty($logEntries)) {
            $headers = $this->getOutputHeadersFromLogEntries($logEntries);
            $entries = $this->getOutputEntriesFromLogEntries($logEntries, $headers);
            $filetype = $importRecordModel->get("filetype");
            $filename = $importRecordModel->get("filename");
            $fileWriter = ITS4YouImport_FileWriter_Writer::factory($this->getOutputFileName($filename), $filetype);
            /* @var $fileWriter ITS4YouImport_FileWriter_Writer */
            $fileWriter->output($headers, $entries);
        } else {
            $moduleName = $request->getModule();
            $response = new Vtiger_Response();
            $response->setError(200, vtranslate('LBL_EMPTY_LOGS', $moduleName));
            $response->emit();
        }
    }

    private function getOutputHeadersFromLogEntries($logEntries)
    {
        $headers = array();
        foreach ($logEntries as $logEntry) {
            /* @var $logEntry ITS4YouImport_DataLogEntry_Model */
            $itemData = $logEntry->getItemData();
            $headers = array_keys($itemData);
            break;
        }

        // handle translation of column header
        $adb = PearDatabase::getInstance();
        $transSql = "SELECT DISTINCT fieldname, fieldlabel FROM vtiger_field WHERE tabid = ? AND fieldname IN (" . generateQuestionMarks($headers) . ")";
        $transResult = $adb->pquery($transSql, array_merge(array(getTabid($this->targetModule)), $headers));
        $transHeaders = array();
        while ($transRow = $adb->fetchByAssoc($transResult)) {
            $transHeaders[$transRow["fieldname"]] = vtranslate($transRow["fieldlabel"], $this->targetModule);
        }

        //sort translated headers by original headers
        $sortedTransHeaders = array();
        $sortedTransHeaders['id'] = vtranslate("LBL_LINE_ID", "ITS4YouImport");
        $sortedTransHeaders['log_message'] = vtranslate("LBL_LOG_MESSAGE", "ITS4YouImport");
        for ($i = 0; $i < count($headers); $i++) {
            if (isset($transHeaders[$headers[$i]])) {
                $sortedTransHeaders[$headers[$i]] = $transHeaders[$headers[$i]];
            } else {
                $sortedTransHeaders[$headers[$i]] = $headers[$i];
            }
        }

        return $sortedTransHeaders;
    }

    private function getOutputEntriesFromLogEntries($logEntries, $headers)
    {
        $outputEntries = array();
        $outputEntriesIdx = 0;
        foreach ($logEntries as $logEntry) {
            /* @var $logEntry ITS4YouImport_DataLogEntry_Model */
            $itemData = $logEntry->getItemData();

            $logMessageText = "";
            $logMessage = $logEntry->getLogMessage(ITS4YouImport_LogMessage_Model::$LOG_MSG_TYPE_ERROR);
            /* @var $logMessage ITS4YouImport_LogMessage_Model */
            if (empty($logMessage)) {
                $logMessage = $logEntry->getLogMessage(ITS4YouImport_LogMessage_Model::$LOG_MSG_TYPE_WARNING);
            }
            if (!empty($logMessage)) {
                $logMessageText = $logMessage->getMessageText();
            }

            foreach ($headers as $fieldName => $fieldLabel) {
                switch ($fieldName) {
                    case self::$LOG_ENTRY_ID_KEY:
                        $outputEntries[$outputEntriesIdx][] = $logEntry->getId();
                        break;

                    case self::$LOG_MESSAGE_KEY:
                        $outputEntries[$outputEntriesIdx][] = $logMessageText;
                        break;

                    default:
                        $outputEntries[$outputEntriesIdx][] = $itemData[$fieldName];
                }
            }
            $outputEntriesIdx++;

//            $generalData = array($logEntry->getId(), $logMessageText);
//            $outputEntries[] = array_merge($generalData, array_values($itemData));
        }

        return $outputEntries;
    }

    private function getOutputFileName($inputFileName)
    {
        list($base, $sufix) = explode(".", $inputFileName, 2);
        return $base . "_failed";
    }

    private function getOutputEntriesFromImportDetails($importDetails)
    {
        $entries = array();

        $idx = 0;
        foreach ($importDetails as $typeOfDetails => $detailedModels) {
            if ($typeOfDetails == "headers" || $typeOfDetails == "transHeaders") {
                continue;
            }

            foreach ($detailedModels as $detailedModel) {
                /* @var $detailedModel Vtiger_Base_Model */
                $detailedModelData = $detailedModel->getData();
                foreach ($detailedModelData as $dataName => $dataVal) {
//                    if ($dataName == "log_message" || $dataName == "id") {
//                        continue;
//                    }
                    if ($dataName == "log_message_type") {
                        continue;
                    }
                    $entries[$idx][] = $dataVal;
                }
                $idx++;
            }
        }

        return $entries;
    }

    private function getOutputHeadersFromImportDetails($importDetails)
    {
        $headers = $importDetails["transHeaders"];
        return $headers;
    }

}
