<?php
/*********************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

include_once 'modules/Vtiger/CRMEntity.php';

class ITS4YouImport extends CRMEntity
{
    public $column_fields;
    public $log;
    public $db;
    public $table_name = 'its4you_imports';
    public $table_index = 'importid';

    /**
     * @var string
     */
    public $moduleName = 'ITS4YouImport';
    public $parentName = 'Tools';

    /**
     * Mandatory table for supporting custom fields.
     */
    public $customFieldTable = array('its4you_importscf', 'importid');

    /**
     * Mandatory for Saving, Include tables related to this module.
     */
    public $tab_name = array('vtiger_crmentity', 'its4you_imports', 'its4you_importscf');

    /**
     * Mandatory for Saving, Include tablename and tablekey columnname here.
     */
    public $tab_name_index = array(
        'vtiger_crmentity' => 'crmid',
        'its4you_imports' => 'importid',
        'its4you_importscf' => 'importid'
    );

    /**
     * Mandatory for Listing (Related listview)
     */
    public $list_fields = array(
        /* Format: Field Label => Array(tablename, columnname) */
        // tablename should not have prefix 'vtiger_'
        'Import name' => array('imports' => 'importname'),
        'Target Module' => array('imports' => 'target_module'),
        'Assigned To' => array('crmentity' => 'smownerid'),
        'Created Time' => array('crmentity' => 'createdtime'),
        'Total count' => array('imports' => 'count_total'),
        'Success. count' => array('imports' => 'count_ok'),
        'Failed count' => array('imports' => 'count_fail')
    );
    public $list_fields_name = array(
        /* Format: Field Label => fieldname */
        'Import name' => 'importname',
        'Target Module' => 'target_module',
        'Assigned To' => 'assigned_user_id',
        'Created Time' => 'createdtime',
        'Total count' => 'count_total',
        'Success. count' => 'count_ok',
        'Failed count' => 'count_fail',
    );
    // Make the field link to detail view from list view (Fieldname)
    public $list_link_field = 'import_no';
    // For Popup listview and UI type support
    public $search_fields = array(
        /* Format: Field Label => Array(tablename, columnname) */
        // tablename should not have prefix 'vtiger_'
        'Import No' => array('imports', 'import_no')
    );
    public $search_fields_name = array(
        /* Format: Field Label => fieldname */
        'Import No' => 'import_no'
    );
    // For Popup window record selection
    public $popup_fields = array('import_no');
    // For Alphabetical search
    public $def_basicsearch_col = 'import_no';
    // Column value to use on detail view record text display
    public $def_detailview_recname = 'import_no';
    // Used when enabling/disabling the mandatory fields for the module.
    // Refers to vtiger_field.fieldname values.
    public $mandatory_fields = array('createdtime', 'modifiedtime', 'import_no');
    // Callback function list during Importing
    public $default_order_by = 'import_no';
    public $default_sort_order = 'ASC';
    // For workflows update field tasks is deleted all the lineitems.
    public $isLineItemUpdate = true;
    // public $update_product_array = Array();
    // This is used to retrieve related vtiger_fields from form posts.
    public $additional_column_fields = array('assigned_user_name', 'smownerid');
    /**
     * name, handler, frequency, module, sequence, description
     */
    public $registerCron = array(
        array(
            'XLSImport',
            'modules/ITS4YouImport/cron/ScheduledImport.service',
            900,
            'ITS4YouImport',
            0,
            'Recommended frequency for scheduled XLSImport is 15 mins'
        ),
    );
    /**
     * [module, type, label, url, icon, sequence, handlerInfo]
     * @return array
     */
    public $registerCustomLinks = array();

    public function __construct()
    {
        global $log;

        $this->log = $log;
        $this->db = PearDatabase::getInstance();
        $this->column_fields = getColumnFields('ITS4YouImport');
    }

    public function save_module()
    {
    }

    public function vtlib_handler($moduleName, $eventType)
    {
        require_once 'vtlib/Vtiger/Cron.php';
        require_once 'vtlib/Vtiger/Module.php';
        require_once 'modules/ModTracker/ModTracker.php';
        require_once 'modules/ModComments/ModComments.php';

        $this->retrieveCustomLinks();

        switch ($eventType) {
            case 'module.enabled':
            case 'module.postinstall':
                $this->updateCron();
            case 'module.postupdate':
                $this->addCustomLinks();
                break;
            case 'module.preuninstall':
            case 'module.disabled':
                $this->updateCron(false);
            case 'module.preupdate':
                $this->deleteCustomLinks();
                break;
        }
    }

    public function retrieveCustomLinks()
    {
        $type = 'v7' === Vtiger_Viewer::getDefaultLayoutName() ? 'DETAILVIEW' : 'DETAILVIEWBASIC';

        $this->registerCustomLinks[] = array(
            'PriceBooks',
            $type,
            'XLS Import Products',
            'index.php?module=ITS4YouImport&view=Edit&targetModule=PriceBooks&sourceRecord=$RECORD$',
        );
    }

    public function updateCron($register = true)
    {
        $this->db->pquery('ALTER TABLE vtiger_cron_task MODIFY COLUMN id INT auto_increment ');

        foreach ($this->registerCron as $cronInfo) {
            list($name, $handler, $frequency, $module, $sequence, $description) = $cronInfo;

            Vtiger_Cron::deregister($name);

            if ($register) {
                Vtiger_Cron::register($name, $handler, $frequency, $module, 1, $sequence, $description);
            }
        }
    }

    public function addCustomLinks()
    {
        $this->updateNumbering();
        $this->updateCustomLinks();
        $this->updateTables();

        Settings_MenuEditor_Module_Model::addModuleToApp($this->moduleName, $this->parentName);

        ModComments::addWidgetTo([$this->moduleName]);
        ModTracker::enableTrackingForModule(getTabid($this->moduleName));
    }

    public function updateTables()
    {
        $adb = PearDatabase::getInstance();
        $columns = (array)$adb->getColumnNames('its4you_import_log');

        if (in_array('logdata', $columns)) {
            $this->db->pquery('ALTER TABLE `its4you_import_log` MODIFY `logdata` LONGTEXT');
        }
    }

    public function updateNumbering()
    {
        $this->setModuleSeqNumber('configure', $this->moduleName, 'XI', 1);
        $this->updateMissingSeqNumber($this->moduleName);
    }

    /**
     * @param bool $register
     */
    public function updateCustomLinks($register = true)
    {
        foreach ($this->registerCustomLinks as $customLink) {
            $module = Vtiger_Module::getInstance($customLink[0]);
            $type = $customLink[1];
            $label = $customLink[2];
            $url = str_replace('$LAYOUT$', Vtiger_Viewer::getDefaultLayoutName(), $customLink[3]);

            if ($module) {
                $module->deleteLink($type, $label);

                if ($register) {
                    $module->addLink($type, $label, $url, $customLink[4], $customLink[5], $customLink[6]);
                }
            }
        }
    }

    public function deleteCustomLinks()
    {
        $this->dropImportQueue();
        $this->updateCustomLinks(false);

        ModTracker::disableTrackingForModule(getTabid($this->moduleName));
        ModComments::removeWidgetFrom([$this->moduleName]);
    }

    public function dropImportQueue()
    {
        $this->db->pquery('DROP TABLE IF EXISTS its4you_import_queue');
    }
}
