/*********************************************************************************
 * The content of this file is subject to the ITS4YouImport license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

Vtiger_Edit_Js("ITS4YouImport_Edit_Js", {}, {
    alert: function (message, type = 'error') {
        let params = {
            title: app.vtranslate(message),
            type: type,
        };

        Vtiger_Helper_Js.showPnotify(params);
    },
    debug: function (error, prefix = '') {
        let debug = true;

        if (debug) {
            console.log([prefix, error]);
        }
    },
    registerEvents: function () {
        this._super();
        this.importsPopup();
        let currentStep = jQuery('ul.crumbs').data('current_step').toString();
        switch (currentStep) {
            case "1":
                this.registerStep1Events();
                break;
            case "2":
                this.registerStep2Events();
                this.registerCustomField();
                this.loadDefaultValueWidgetForMappedFields();
                break;
        }
    },
    registerCustomField: function () {
        $('.fieldIdentifier.clone').find('select').select2('destroy');
        $('.editViewHeader').on('click', '.addNewImportField', function () {
            let num = $('.fieldIdentifier:visible').length + 1,
                clone = $('.fieldIdentifier.clone').clone();

            clone.removeClass('hide');
            clone.removeClass('clone');
            clone.attr('id', 'fieldIdentifier' + num)
            clone.find('select').select2();
            clone.find('[name="row_counter"]').val(num);

            $('.addNewImportFieldRow').before(clone);
        });
    },
    importsPopup: function () {
        jQuery('.showPopup').on('click', function () {
            let form = jQuery(this).closest('form').serializeFormData(),
                data0 = jQuery(this).data(),
                data1 = {
                    module: app.getModuleName(),
                    targetModule: form.targetModule,
                    view: 'Popup',
                    start: 1,
                    foruser: form.foruser,
                },
                params = {
                    data: Object.assign(data0, data1),
                };

            app.request.post(params).then(function (error, data) {
                if (!error) {
                    app.helper.showModal(data);
                }
            });
        });
    },
    /* STEP1 logic */
    fileDropzone: null,
    objectDropzone: false,
    setDropzone: function () {
        let self = this,
            maxFileSize = parseInt(jQuery("div.import_file_dropzone").data("max-size")) / 100000;

        Dropzone.options.myAwesomeDropzone = false;
        Dropzone.autoDiscover = false;

        self.objectDropzone = new Dropzone("div.import_file_dropzone", {
            url: "index.php?module=ITS4YouImport&action=UploadImportFile",
            previewTemplate: jQuery('div#dropzone_preview_template').html(),
            maxFiles: 1,
            maxFilesize: maxFileSize,
            uploadMultiple: false,
            autoProcessQueue: true,
            acceptedFiles: ".xls,.xlsx,.csv,.vcf,.txt",
            createImageThumbnails: false,
            paramName: "import_file"
        });

        self.setDropzoneActions();
    },
    setDropzoneActions: function () {
        let self = this;
        //When a file is added to the list
        self.objectDropzone.on('addedfile', function (file) {
            //dropzone specific settings
            //hide 'Drop file ...' message
            jQuery('.import_file_message').hide();
            //adjust file preview layout

            jQuery('div#substep2 button.close').removeClass('hide'); //display Close button

            //highlight div in order to point on fact that file is selected
            jQuery(file.previewElement).appendTo(jQuery('div.import_file_progress').show());
        });
        //Called whenever a file is removed from the list. You can listen to this and delete the file from your server if you want to.
        self.objectDropzone.on('removedfile', function (file) {
            //display initial text 'Drop file here or click to upload'
            jQuery('.import_file_message').show();
            //set the layout of dropzone area to initial state
            jQuery('div.import_file_progress').hide();
            //reinitial the event listener (in order to be clickable)
            self.objectDropzone.setupEventListeners();
            //disable Next button in order to wait till file is uploaded
            jQuery('#step1submit').attr('disabled', 'disabled');
        });
        //Called when the number of files accepted reaches the maxFiles limit.
        self.objectDropzone.on('maxfilesreached', function (files) {
            //remove event listener (in order to avoid further File open dialog, disable clickable)
            self.objectDropzone.removeEventListeners();
            //avoid adding information about files which are above the limit of number of files
            jQuery.each(files, function (idx, file) {
                if (jQuery(file.previewElement).hasClass('dz-error')) {
                    jQuery(file.previewElement).remove();
                }
            });
        });

        //Gets called periodically whenever the file upload progress changes.
        self.objectDropzone.on('uploadprogress', function (file, progress, bytesSent) {
            jQuery('div.import_file_progress').css('width', progress + '%');
            jQuery('div.dropzone_progress', file.previewElement).text(Math.floor(progress).toString() + '%');
        });

        self.objectDropzone.on('complete', function (file) {
            if (file.status === 'success') {
                let response = file.xhr.response,
                    maxImportSize = jQuery('.import_file_dropzone').data('max-size');

                if (file.size > maxImportSize) {
                    self.alert('JS_ERROR_MAX_FILE_SIZE');
                    self.resetSubstep2();
                } else {
                    let data = JSON.parse(response);

                    if (typeof data !== 'object') {
                        self.alert(response);
                    } else {
                        //success
                        //other elements
                        let extension = file.name.match(/[.]([a-zA-Z]+)$/)[1];

                        if (extension) {
                            extension = extension.toLowerCase();
                        }

                        jQuery('div.arrow-down').removeClass('arrow-active'); //de-highlight previouosly highlighted arrows
                        jQuery('.file_type').removeClass('hide'); //display file type specifications
                        jQuery('select#file_type').val(extension).trigger('change'); //preselect file type

                        jQuery('div#substep3').removeClass('hide').find('.arrow-down').addClass('arrow-active'); //display next substep and highlight its arrow
                        jQuery('div#substep4').removeClass('hide').find('.arrow-down').addClass('arrow-active'); //display next substep and highlight its arrow
                        jQuery('div#substep5').removeClass('hide');
                        self.handleFileTypeChange(extension);

                        jQuery('#step1submit').removeAttr('disabled');
                    }
                }
            }
        });
        //Called when a file upload gets canceled
        self.objectDropzone.on('canceled', function (file) {
            self.alert('ALERT_FILE_UPLOAD_CANCELED');
        });
        //An error occured. Receives the errorMessage as second parameter and if the error was due to the XMLHttpRequest the xhr object as third
        self.objectDropzone.on('error', function (file, errorMessage) {
            self.alert(errorMessage);
            //remove added file
            self.resetSubstep2();
        });
    },
    registerStep1Events: function () {
        let self = this,
            tabId = jQuery('select#tabid'),
            subStep1Close = jQuery('div#substep1 button.close');
        //error message div close
        jQuery('div#errmsg button.close').on('click', function () {
            jQuery('div#errmsg').hide();
        });
        //module selection change     
        tabId.on('change', function () {
            if (jQuery(this).val() !== "" && jQuery(this).attr('disabled') !== 'disabled') {
                subStep1Close.removeClass('hide'); //display Close button
                jQuery('select#tabid').attr('disabled', 'disabled').trigger('change'); //disable selectbox and render it as select2
                jQuery('div#substep2').removeClass('hide').find('.arrow-down').addClass('arrow-active'); //display next substep

                self.fillMergeFields(jQuery(this).val());
            }
        });
        if (tabId.is(':disabled')) {
            self.forceMergeFieldsSelect();
        }
        //module selection reset
        subStep1Close.on('click', function () {
            self.resetSubstep1();
        });
        //file selection change
        //Dropzone initialization
        self.setDropzone();
        //file type change
        jQuery('select#file_type').change(function () {
            let fileType = jQuery(this).val()

            if (fileType) {
                self.handleFileTypeChange(fileType.toLowerCase());
            }
        });
        //file selection reset
        jQuery('div#substep2 button.close').on('click', function () {
            self.resetSubstep2();
        });
        //register event handler for submit event - remove disabled attributes
        jQuery('form#EditView').submit(function () {    //TODOvz: possible place of issue id="editStep1Form" replaced with id="EditView"
            if (jQuery('input#handle_duplicates').val() === 'on') {
                if (jQuery('select#merge_fields').val() !== null) {
                    //not needed when dropzone used
                    //jQuery('input#import_file').removeAttr('disabled');

                    jQuery('select#tabid').removeAttr('disabled');
                    return true;
                } else {
                    self.alert('JS_PLEASE_SELECT_ONE_FIELD_FOR_MERGE');
                    return false;
                }
            } else {
                //not needed when dropzone used
                //jQuery('input#import_file').removeAttr('disabled');
                jQuery('select#tabid').removeAttr('disabled');
                return true;
            }
        });
        //duplicates handling
        jQuery('div#substep3 .toggle-button').on('click', function () {
            jQuery(this).toggleClass('toggle-button-selected');
            jQuery('.duplicates_spec').toggleClass('hide');
            if (jQuery(this).hasClass('toggle-button-selected')) {
                jQuery('input#handle_duplicates').val('on');

                const params = {
                    module: app.getModuleName(),
                    action: 'MergeTypes',
                    targetModule: jQuery('[name="targetModule"]').val(),
                }

                app.request.post({data: params}).then(function (error, data) {
                    if (!error) {
                        const mergeType = jQuery('[name="merge_type"]').html('');

                        jQuery.each(data, function (index, value) {
                            let newOption = new Option(value, index, false, false);

                            mergeType.append(newOption).trigger('change');
                        });
                    }
                })
            } else {
                jQuery('input#handle_duplicates').val('off');
            }
        });
        //workflow settings        
//        jQuery('div#substep4 .toggle-button').on('click', function () {
//            jQuery(this).toggleClass('toggle-button-selected');
//            if (jQuery(this).hasClass('toggle-button-selected')) {
//                jQuery('input#trigger_workflow').val('on');
//            } else {
//                jQuery('input#trigger_workflow').val('off');
//            }
//        });

        //additional settings
        jQuery('span.blockToggle').on('click', function () {
            jQuery('span.blockToggle').toggleClass('hide');
            jQuery('div#importSettingsContainer').toggleClass('hide');
        });
    },
    handleFileTypeChange: function (extension) {
        let self = this,
            all = jQuery('.file_spec_csv, .file_spec_vcf, .file_spec_xls');
        switch (extension) {
            case 'xls':
            case 'xlsx':
                all.addClass('hide');
                jQuery('.file_spec_xls').removeClass('hide'); //display xls spec 
                break;
            case 'csv':
            case 'txt':
                all.addClass('hide');
                jQuery('.file_spec_csv').removeClass('hide'); //display file specifications
                break;
            case 'vcf':
                all.addClass('hide');
                jQuery('.file_spec_vcf').removeClass('hide'); //display file specifications                
                break;
            default:
                self.resetSubstep2();
                self.alert('ALERT_INCORRECT_FILE_TYPE');
        }
    },
    fillMergeFields: function (targetModule) {
        let self = this,
            progressIndicatorElement = jQuery.progressIndicator();

        jQuery('select#merge_fields option').remove();
        jQuery.ajax('index.php?module=ITS4YouImport&action=GetMergeFields&targetModule=' + targetModule)
            .always(function () {
                progressIndicatorElement.hide();
            })
            .done(function (response) {
                if (response.success === true) {
                    self.unhideDuplicateHandlingDiv();

                    jQuery.each(response.result, function (key, item) {
                        jQuery('select#merge_fields').append('<option value="' + key + '" ' + item.selectedAttribute + ' ' + item.dataAttribute + '>' + item.displayValue + '</option>');
                    });
                    self.forceMergeFieldsSelect();
                    //updated content of chosen element
                    jQuery('select#merge_fields').trigger('change');
                } else {
                    self.hideDuplicateHandlingDiv();
                    self.alert(response.error.message, 'warning');
                }
            })
            .fail(function (response) {
                self.hideDuplicateHandlingDiv();
                self.alert(response);
            });
    },
    hideDuplicateHandlingDiv: function () {
        let subStep = jQuery('span#finalSubstepNumber');
        jQuery('div#substep3').addClass('alwaysHide');
        subStep.text(parseInt(subStep.data('originalValue')) - 1);
    },
    unhideDuplicateHandlingDiv: function () {
        let subStep = jQuery('span#finalSubstepNumber');
        jQuery('div#substep3').removeClass('alwaysHide');
        subStep.text(parseInt(subStep.data('originalValue')));
    },
    forceMergeFieldsSelect: function () {
        //forced hack of setting correct width of chosen element

        //TODOvz: Check it when module is changed
        //let chosenElement = app.getChosenElementFromSelect(jQuery('select#merge_fields'));
        //chosenElement.css('width', '100%');
        //jQuery('div.chzn-drop', chosenElement).css('width', '100%');
    },
    hideDependentSubsteps: function (masterSubstepNo) {
        jQuery('div#substeps div.stepBlock').each(function (index, item) {
            let thisItem = jQuery(item),
                subStep = thisItem.data('substep');
            if (subStep > masterSubstepNo) {
                thisItem.addClass('hide');
            }
        });
    },
    resetSubstep1: function () {
        let self = this;
        jQuery('select#tabid').removeAttr('disabled').val('').trigger('change'); //enable selectbox => reset it => render it as select2
        jQuery('div#substep1 button.close').addClass('hide'); //hide Close button

        self.objectDropzone.removeAllFiles(true);

        self.hideDependentSubsteps('1'); //hide all subsequent substeps
        self.resetSubstep2();
    },
    resetSubstep2: function () {
        let self = this;

        self.objectDropzone.removeAllFiles(true);

        jQuery('div#substep2 button.close').addClass('hide'); //hide Close button
        jQuery('.file_type').addClass('hide'); //hide file type row
        jQuery('.file_spec_csv').addClass('hide'); //hide other file specifications for CSV based files
        jQuery('select#file_encoding, select#delimiter').prop('selectedIndex', 0).trigger('change'); //reset file encoding select option to first //reset delimeter select option to first
        jQuery('input#has_header').prop('checked', true); //reset checkbox has header to checked
        jQuery('div#substep2 div.arrow-down').addClass('arrow-active'); //highlight arrow to substep 2

        self.hideDependentSubsteps('2');
        self.resetSubstep3();
    },
    resetSubstep3: function () {
        let mergeFields = jQuery('select#merge_fields');

        jQuery('.toggle-button').removeClass('toggle-button-selected');
        jQuery('.duplicates_spec').addClass('hide');
        jQuery('select#merge_type').prop('selectedIndex', 0).trigger('change'); //reset duplicates handling method select option to first
        //reset duplicates fields select 
        mergeFields.val('');
        mergeFields.find('option[data-is_default="true"]').attr('selected', 'selected');
        mergeFields.trigger('change');

        jQuery('[name="trigger_workflow"], [name="create_picklist_values"]').prop("checked", false);
    },
    /* STEP2 logic */
    registerStep2Events: function () {
        let self = this,
            container = $('#EditView');

        container.on('change', 'select#saved_maps', function () {
            self.loadSavedMap();
        });
        container.on('click', 'span#delete_map_container i', function () {
            self.deleteMap($('input#targetModule').val());
        });
        container.on('change', 'select[name="mapped_fields"]', function () {
            self.loadDefaultValueWidget($(this).parent().parent().attr('id'));
        });
        container.on('click', 'input#save_map', function () {
            let saveMapAs = $('input#save_map_as');

            if ($(this).is(':checked')) {
                saveMapAs.removeAttr('disabled');
            } else {
                saveMapAs.attr('disabled', 'disabled');
            }
        });
        container.on('click', 'button#importButton', function (evt) {
            evt.preventDefault();

            if (self.sanitizeAndSubmit()) {
                if (true === $(this).data("importinbackground")) {
                    let message = {
                        'message': app.vtranslate('CONFIRM_BYPASS_BACKGROUND_IMPORT'),
                    };
                    app.helper.showConfirmationBox(message).done(function () {
                        $('input#bypassBackgroundImport').val('true');
                        $('form.editStep2Form').submit();
                    }).fail(function () {
                        $('input#bypassBackgroundImport').val('false');
                        $('form.editStep2Form').submit();
                    });
                } else {
                    $('form.editStep2Form').submit();
                }
            }
        });
    },
    loadSavedMap: function () {
        let self = this;
        let selectedMapElement = jQuery('#saved_maps option:selected');
        let mapId = selectedMapElement.attr('id');
        let fieldsList = jQuery('.fieldIdentifier');
        let deleteMapContainer = jQuery('#delete_map_container');
        fieldsList.each(function (i, element) {
            let fieldElement = jQuery(element);
            jQuery('[name=mapped_fields]', fieldElement).val('');
        });
        if (mapId === -1) {
            deleteMapContainer.hide();
            return;
        }
        deleteMapContainer.show();
        let mappingString = selectedMapElement.val();

        if (mappingString === '')
            return;
        let mappingPairs = mappingString.split('&');
        let mapping = {};
        for (let i = 0; i < mappingPairs.length; ++i) {
            let mappingPair = mappingPairs[i].split('=');
            let header = mappingPair[0];
            header = header.replace(/\/eq\//g, '=');
            header = header.replace(/\/amp\//g, '&');
            mapping["'" + header + "'"] = mappingPair[1];
        }
        fieldsList.each(function (i, element) {
            let fieldElement = jQuery(element);
            let mappedFields = jQuery('[name=mapped_fields]', fieldElement);
            let rowId = jQuery('[name=row_counter]', fieldElement).get(0).value;
            let headerNameElement = jQuery('[name=header_name]', fieldElement).get(0);
            let headerName = jQuery(headerNameElement).html();
            if ("'" + headerName + "'" in mapping) {
                mappedFields.val(mapping["'" + headerName + "'"]);
            } else if (rowId in mapping) {
                mappedFields.val($rowId);
            }
            mappedFields.trigger('change');
            self.loadDefaultValueWidget(fieldElement.attr('id'));
        });
    },
    loadDefaultValueWidget: function (rowIdentifierId) {
        let affectedRow = jQuery('#' + rowIdentifierId);
        if (typeof affectedRow == 'undefined' || affectedRow == null)
            return;
        let selectedFieldElement = jQuery('[name=mapped_fields]', affectedRow).get(0);
        let selectedFieldName = jQuery(selectedFieldElement).val();
        let defaultValueContainer = jQuery(jQuery('[name=default_value_container]', affectedRow).get(0));
        let allDefaultValuesContainer = jQuery('#defaultValuesElementsContainer');
        if (defaultValueContainer.children.length > 0) {
            let copyOfDefaultValueWidget = jQuery(':first', defaultValueContainer).detach();
            copyOfDefaultValueWidget.appendTo(allDefaultValuesContainer);
        }
        let selectedFieldDefValueContainer = jQuery('#' + selectedFieldName + '_defaultvalue_container', allDefaultValuesContainer);
        let defaultValueWidget = selectedFieldDefValueContainer.detach();
        defaultValueWidget.appendTo(defaultValueContainer);
    },
    loadDefaultValueWidgetForMappedFields: function () {
        let self = this,
            fieldsList = jQuery('.fieldIdentifier');

        fieldsList.each(function (i, element) {
            let fieldElement = jQuery(element),
                mappedFieldName = jQuery('[name=mapped_fields]', fieldElement).val();

            if (mappedFieldName !== '') {
                self.loadDefaultValueWidget(fieldElement.attr('id'));
            }
        });
    },
    deleteMap: function (module) {
        let message = {
            message: app.vtranslate('LBL_DELETE_CONFIRMATION'),
        };
        app.helper.showConfirmationBox(message).done(function () {
            let selectedMapElement = jQuery('#saved_maps option:selected'),
                mapId = selectedMapElement.attr('id'),
                postData = {
                    "module": "ITS4YouImport",
                    "targetModule": module,
                    "view": 'Edit',
                    "mode": 'deleteMap',
                    "mapid": mapId
                };

            AppConnector.request(postData).then(function (data) {
                let html = data.result,
                    mapsContainer = jQuery('#savedMapsContainer');

                mapsContainer.html(html);
                app.changeSelectElementView(mapsContainer);

            }, function (error, err) {

            });
        });
    },
    sanitizeAndSubmit: function () {
        let self = this;
        if (!self.sanitizeFieldMapping())
            return false;
        return self.validateCustomMap();
    },
    sanitizeFieldMapping: function () {
        let self = this,
            fieldsList = jQuery('.fieldIdentifier'),
            mappedFields = {},
            mappedDefaultValues = {};

        for (let i = 0; i < fieldsList.length; ++i) {
            let fieldElement = jQuery(fieldsList.get(i));
            let rowId = jQuery('[name=row_counter]', fieldElement).get(0).value;
            let selectedFieldElement = jQuery('select option:selected', fieldElement);
            let selectedFieldName = selectedFieldElement.val();
            let selectedFieldDefaultValueElement = jQuery('#' + selectedFieldName + '_defaultvalue', fieldElement);
            let defaultValue = '';
            if (selectedFieldDefaultValueElement.attr('type') === 'checkbox') {
                defaultValue = selectedFieldDefaultValueElement.is(':checked');
            } else {
                defaultValue = selectedFieldDefaultValueElement.val();
            }
            if (selectedFieldName !== '') {
                if (selectedFieldName in mappedFields) {
                    let errorMessage = app.vtranslate('JS_FIELD_MAPPED_MORE_THAN_ONCE') + " " + selectedFieldElement.data('label');
                    self.alert(errorMessage);
                    return false;
                }
                mappedFields[selectedFieldName] = rowId - 1;
                if (defaultValue !== '') {
                    mappedDefaultValues[selectedFieldName] = defaultValue;
                }
            }
        }

        let mandatoryFields = JSON.parse(jQuery('#mandatory_fields').text());
        let moduleName = app.getModuleName();
        if (moduleName === 'PurchaseOrder' || moduleName === 'Invoice' || moduleName === 'Quotes' || moduleName === 'SalesOrder') {
            mandatoryFields.hdnTaxType = app.vtranslate('Tax Type');
        }
        let missingMandatoryFields = [];
        for (let mandatoryFieldName in mandatoryFields) {
            if (mandatoryFieldName in mappedFields) {

            } else {
                missingMandatoryFields.push('"' + mandatoryFields[mandatoryFieldName] + '"');
            }
        }
        if (missingMandatoryFields.length > 0) {
            let errorMessage = app.vtranslate('JS_MAP_MANDATORY_FIELDS') + missingMandatoryFields.join(',');
            self.alert(errorMessage);
            return false;
        }
        jQuery('#field_mapping').val(JSON.stringify(mappedFields));
        jQuery('#default_values').val(JSON.stringify(mappedDefaultValues));
        return true;
    },
    validateCustomMap: function () {
        let self = this,
            saveMap = jQuery('#save_map').is(':checked');
        if (saveMap) {
            let mapName = jQuery('#save_map_as').val();
            if (jQuery.trim(mapName) === '') {
                let errorMessage = app.vtranslate('JS_MAP_NAME_CAN_NOT_BE_EMPTY');
                self.alert(errorMessage);
                return false;
            }
            let mapOptions = jQuery('#saved_maps option');
            for (let i = 0; i < mapOptions.length; ++i) {
                let mapOption = jQuery(mapOptions.get(i));
                if (mapOption.html() === mapName) {
                    let errorMessage = app.vtranslate('JS_MAP_NAME_ALREADY_EXISTS');
                    self.alert(errorMessage);
                    return false;
                }
            }
        }
        return true;
    },
});


