/*********************************************************************************
 * The content of this file is subject to the FieldMapping 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * *******************************************************************************/

/** @var ITS4YouFieldMapping_HS_Js */
jQuery.Class('ITS4YouFieldMapping_HS_Js', {
    viewType: false,
    formElement: false,
    debugOn: false,
    queryParams: [],
    requestedMappings: [],
    showError: function (message) {
        let params = {
            text: app.vtranslate(message),
            type: 'error'
        };

        Vtiger_Helper_Js.showMessage(params);
    },
    registerReference: function (view) {
        const self = this;

        self.viewType = view;

        jQuery(document).on('Vtiger.Reference.Selection', function (e, data) {
            let selectElement = jQuery(e.target),
                forFieldName = selectElement.attr('name');

            self.checkMappings(forFieldName, selectElement.val());
        });
    },
    getForm: function () {
        if (!this.formElement) {
            this.setForm(jQuery('#EditView'));
        }

        return this.formElement;
    },
    setForm: function (element) {
        this.formElement = element;
        return this;
    },
    setDebugText: function (text) {
        if (window.console && this.debugOn) console.log('[ITS4YouDynamicFields] ', text);
    },
    getQueryParams: function () {
        let self = this,
            qs = document.location.search,
            params = {},
            tokens,
            re = /[?&]?([^=]+)=([^&]*)/g;

        qs = qs.split("+").join(" ");

        while (tokens = re.exec(qs)) {
            params[decodeURIComponent(tokens[1])] = decodeURIComponent(tokens[2]);
        }

        self.queryParams = params;

        return params;
    },
    getDataParams: function (mappingId, sourceRecord) {
        const self = this,
            actionParams = {
                module: 'ITS4YouFieldMapping',
                action: 'GetData',
                its4youfieldmappingid: mappingId,
                sourceRecord: sourceRecord,
                productblock: '0',
                mode: 'Fields',
            };

        for (fieldKey in self.queryParams) {
            if (-1 === jQuery.inArray(fieldKey, self.requestSkipFields)) {
                actionParams[fieldKey] = self.queryParams[fieldKey];
            }
        }

        return actionParams;
    },
    getData: function (formName, mappingId, sourceRecord) {
        let self = this,
            queryParams = self.queryParams;

        if (typeof sourceRecord == 'undefined') {
            sourceRecord = queryParams.sourceRecord;
        }

        let actionParams = self.getDataParams(mappingId, sourceRecord);

        app.request.post({data: actionParams}).then(function (error, data) {
            if (!error) {
                jQuery.each(data, function (fieldName, fieldValue) {
                    if ('relatedProducts' !== fieldName) {
                        self.setField(formName, fieldName, fieldValue);
                    } else if ('true' === fieldValue) {
                        self.setItemDetails(formName, mappingId, sourceRecord);
                    } else {
                        self.setDebugText(this);
                    }
                });

                if ('QuickCreate' === formName) {
                    self.addQuickCreateFields({
                        'fieldmappingid': mappingId,
                        'sourceRecord': sourceRecord,
                        'sourceModule': app.getModuleName(),
                    });
                }
            }
        });
    },
    setField: function (formName, fieldName, fieldValue) {
        const self = this,
            form = jQuery('#' + formName),
            fieldByName = form.find(':input[name=' + fieldName + ']'),
            fieldById = form.find('[id*="_editView_fieldName_' + fieldName + '"]'),
            displayField = form.find(':input[name=' + fieldName + '_display]'),
            displayUiType = [1, 2, 3, 4, 11, 15, 17, 19, 20, 21, 22, 27, 28, 33, 85, 55, 255, 5, 23, 61, 69, 71];

        let value = fieldValue['source'];

        if (!isNaN(value) && fieldName && 'assigned_user_id' !== fieldName) {
            if (isNaN(fieldValue['display'])) {
                value = fieldValue['display'];
            }
        }

        if (-1 < displayUiType.indexOf(parseInt(fieldValue['uiType']))) {
            value = fieldValue['display'];
        }

        if (fieldByName.is('[type="checkbox"]') || fieldById.is('[type="checkbox"]')) {
            if (fieldValue['source'] === '1') {
                fieldByName.attr('checked', true).trigger('change');
                value = 1;
            }
        }

        if (fieldByName.is('textarea')) {
            let fieldId = fieldByName.attr('id');

            value = fieldValue['source'];

            fieldByName.text(value);

            if (fieldId && CKEDITOR.instances[fieldId]) {
                CKEDITOR.instances[fieldId].setData(value);
            }
        }

        if (fieldByName.is('.sourceField')) {
            value = fieldValue['source'];
        }

        fieldByName.val(value);

        if (fieldName !== 'currency_id') {
            fieldByName.trigger('change');

            if (displayField.length && !self.isRequestedMapping(fieldValue['source'])) {
                let fieldDropDown = jQuery('#' + app.getModuleName() + '_' + formName + '_fieldName_' + fieldName + '_dropDown'),
                    tdElement = fieldByName.closest('td'),
                    referenceModules = tdElement.prev('.fieldLabel').find('.referenceModulesList'),
                    selectedItemData = {
                        'id': parseInt(fieldValue['source']),
                        'name': fieldValue['display']
                    };

                if (fieldDropDown.length) {
                    fieldDropDown.val(fieldValue['entityType'].trigger('liszt:updated').trigger('change'));
                }

                if (referenceModules.length) {
                    referenceModules.val(fieldValue['entityType']).trigger('change');
                }

                Vtiger_Edit_Js.getInstance().setReferenceFieldValue(tdElement, selectedItemData);
            }
        }

        if ('select-one' === fieldByName.prop('type') || 'currency_id' === fieldName) {
            fieldByName.trigger('liszt:updated');
        }

        if (fieldByName.is('.select2')) {
            let split = fieldValue['source'].split(' |##| ');

            fieldByName.select2('val', split);
        }
    },
    isInventory: function () {
        return this.getLineItemTab().length;
    },
    getLineItemTab: function () {
        return $('#lineItemTab');
    },
    getLineItemRow: function () {
        return $('.lineItemRow');
    },
    isProductsExists: function () {
        let result = false;

        $('.productName').each(function () {
            if ($(this).val().length) {
                result = true;
            }
        });

        return result;
    },
    setItemDetails: function (formName, mappingId, sourceRecord) {
        const self = this;

        if (self.isInventory() && !self.isProductsExists()) {
            let params = {
                module: 'ITS4YouFieldMapping',
                action: 'GetData',
                mode: 'Products',
                mappingId: mappingId,
                sourceRecord: sourceRecord,
                targetModule: app.getModuleName(),
            };

            app.request.post({data: params}).then(function (error, data) {
                if (!error && data['success'] && data['items']) {
                    self.clearItems();
                    self.updateItemsFields(data);
                    self.updateItems(data['items']);
                }
            });
        }
    },
    clearItems: function () {
        this.getLineItemContainer().find('.deleteRow').trigger('click');
    },
    updateItemsFields: function (data) {
        const region = $('#region_id'),
            currency = $('#currency_id'),
            taxType = $('#taxtype');

        if (region.is(':visible')) {
            region.select2('val', data['regionId']).trigger('change');
        }
        if (currency.is(':visible')) {
            currency.select2('val', data['currencyId']).trigger('change');
        }

        if(taxType.is(':visible')) {
            taxType.select2('val', data['taxType']).trigger('change');
        }

        if(data['discount']) {
            const type = data['discount']['type'];

            if(type) {
                $('.finalDiscounts[data-discount-type="' + type + '"]').attr('checked', true);
                $('#discount_' + type + '_final').val(data['discount'][type]);
                $('.qty:first-child').trigger('focusout');
            }
        }
    },
    getLineItemContainer: function () {
        return jQuery('.lineitemTableContainer');
    },
    updateMissingItemDetails: function (qtyElement, itemData) {
        const row = qtyElement.parents('tr.lineItemRow'),
            discountType = itemData['discount']['type'],
            discountValue = itemData['discount'][discountType];

        qtyElement.val(itemData['qty']);

        if (discountType && discountValue) {
            row.find('.discounts[data-discount-type="' + discountType + '"]').prop('checked', true);
            row.find('.discount_' + discountType).val(discountValue);
        }

        qtyElement.trigger('focusout');
    },
    updateItems: function (items) {
        const self = this;

        $.each(items, function (index, items) {
            $.each(items, function (itemId, itemData) {
                self.getLineItemContainer().one('focusout', '.qty', function () {
                    const qtyElement = $(this);

                    self.updateMissingItemDetails(qtyElement, itemData);
                });

                if ('Products' === itemData['type']) {
                    $('#addProduct').trigger('click', items);
                } else if ('Services' === itemData['type']) {
                    $('#addService').trigger('click', items);
                }
            });
        });
    },
    addQuickCreateFields: function (fields) {
        jQuery.each(fields, function (name, value) {
            jQuery('<input>').attr({
                type: 'hidden',
                id: name,
                name: name,
                value: value,
            }).appendTo('#QuickCreate');
        });
    },
    fillFields: function (formName) {
        let self = this,
            request = self.queryParams;

        if (!request.its4youfieldmappingid && request.sourceModule && request.sourceRecord) {
            let actionParams = {
                module: 'ITS4YouFieldMapping',
                action: 'GetFieldMappingId',
                sourceModule: request.sourceModule,
                sourceRecord: request.sourceRecord,
                forModule: app.getModuleName(),
            };

            app.request.post({data: actionParams}).then(function (error, data) {
                if (!error) {
                    self.getData(formName, data['mappingId']);
                } else {
                    self.setDebugText(error);
                }
            });
        } else if (request.its4youfieldmappingid) {
            self.getData(formName, request.its4youfieldmappingid);
        }
    },
    requestSkipFields: [
        'index.php?module',
        'module',
        'view',
        'action',
        'sourceModule',
        'sourceRecord',
        'its4youfieldmappingid',
        'mode',
    ],
    recordNameParams: {
        module: 'ITS4YouFieldMapping',
        action: 'GetData',
        mode: 'RecordName',
    },
    fillRequestFields: function (fromName) {
        let self = this;

        $.each(self.queryParams, function (key, value) {
            if (-1 === $.inArray(key, self.requestSkipFields)) {
                self.recordNameParams.record = value;

                app.request.post({data: self.recordNameParams}).then(function (error, data) {
                    if (!error) {
                        self.setField(fromName, key, {display: data['recordName'], source: value, uiType: 10, entityType: data['moduleName']});
                    }
                });

            }
        });
    },
    checkMappings: function (forFieldName, fieldValue) {
        if (fieldValue && forFieldName) {
            let self = this,
                actionParams = {
                    module: 'ITS4YouFieldMapping',
                    action: 'GetMappingsForModule',
                    forModule: app.getModuleName(),
                    forField: forFieldName,
                };

            app.request.post({data: actionParams}).then(function (error, data) {
                if (!error) {
                    self.setRequestedMapping(fieldValue);
                    self.getData('EditView', data['mappingId'], fieldValue);
                } else {
                    self.setDebugText(error);
                }
            });
        }
    },
    isRequestedMapping: function (value) {
        return 'undefined' !== typeof this.requestedMappings[value];
    },
    setRequestedMapping: function (value) {
        this.requestedMappings.push(value);
    },
    addSourceField: function () {
        let self = this,
            query = self.queryParams,
            form = self.getForm();

        if (self.validateRelation(query)) {
            self.addRelationFields(form, query);
        }
    },
    validateRelation: function (data) {
        return data.its4youfieldmappingid && data.sourceModule && data.sourceRecord
    },
    getQuickParams: function () {
        let self = this,
            qs = window.field_mapping_url,
            params = {},
            tokens,
            re = /[?&]?([^=]+)=([^&]*)/g;

        qs = qs.split("+").join(" ");

        while (tokens = re.exec(qs)) {
            params[decodeURIComponent(tokens[1])] = decodeURIComponent(tokens[2]);
        }

        self.queryParams = params;

        return params;
    },
    addQuickSourceField: function () {
        let self = this,
            query = self.queryParams,
            form = jQuery('form[name="QuickCreate"]');

        if (self.validateRelation(query)) {
            self.addRelationFields(form, query);
        }
    },
    addRelationFields: function (form, data) {
        let record = form.find('input[name="record"]');

        if (!form.find('input[name="sourceModule"]').length && !form.find('input[name="sourceRecord"]').length) {
            record.after('<input type="hidden" name="sourceModule" value="' + data.sourceModule + '"/>');
            record.after('<input type="hidden" name="sourceRecord" value="' + data.sourceRecord + '"/>');
        }
    },
    triggerReferenceFields: function (formName) {
        const self = this;

        app.event.one('ProcessFlow.Actions.Loaded', function () {
            let referenceData = self.queryParams,
                formElement = $('#' + formName);

            if (self.queryParams['its4youfieldmappingid']) {
                $('#' + formName + ' :input').each(function () {
                    let element = $(this),
                        name = element.attr('name'),
                        displayName = name + '_display',
                        displayElement = $('[name="' + displayName + '"]');

                    if (element.val() && displayElement.val()) {
                        referenceData[name] = element.val();
                    }
                });
            }

            $.each(referenceData, function (fieldName, fieldValue) {
                if (fieldValue && -1 === $.inArray(fieldName, ['module', 'view', 'sourceModule', 'sourceRecord', 'its4youfieldmappingid', 'app']) && 0 !== fieldName.indexOf('return')) {
                    let fieldElement = formElement.find('input[name="' + fieldName + '"]'),
                        fieldDisplayElement = formElement.find('input[name="' + fieldName + '_display"]'),
                        fieldContainer = fieldElement.parents('td'),
                        fieldReferenceElement = fieldContainer.find('input[name="popupReferenceModule"]').length ? fieldContainer.find('input[name="popupReferenceModule"]') : fieldContainer.find('input.popupReferenceModule'),
                        recordId = parseInt(fieldElement.val());

                    if (recordId) {
                        fieldElement.trigger(Vtiger_Edit_Js.referenceSelectionEvent, {'source_module': fieldReferenceElement.val(), 'record': recordId, 'selectedName': fieldDisplayElement.val()});
                    }
                }
            });
        })
    },

}, {});

jQuery(function () {
    let view = app.getViewName();

    if ('Edit' === view) {
        ITS4YouFieldMapping_HS_Js.getQueryParams();
        ITS4YouFieldMapping_HS_Js.addSourceField();
        ITS4YouFieldMapping_HS_Js.registerReference(view);
        ITS4YouFieldMapping_HS_Js.triggerReferenceFields('EditView');
        ITS4YouFieldMapping_HS_Js.fillFields('EditView');
    }

    app.event.on('post.QuickCreateForm.show', function (event, form) {
        if (window.field_mapping_url) {
            ITS4YouFieldMapping_HS_Js.getQuickParams();
            ITS4YouFieldMapping_HS_Js.addQuickSourceField();
            ITS4YouFieldMapping_HS_Js.registerReference(view);
            ITS4YouFieldMapping_HS_Js.fillFields('QuickCreate');
            ITS4YouFieldMapping_HS_Js.fillRequestFields('QuickCreate');
        }
    });
});
