<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

/**
 * @param $entity
 *
 * @throws Exception
 */
function updateInventoryProductRelCreditNotes($entity) {
    global $log, $adb, $cnBeforeStatus;

    $entityId = vtws_getIdComponents($entity->getId());
    $entityId = $entityId[1];
    $status = $entity->get(CreditNotes4You::$statusFieldName);
    if (!$cnBeforeStatus) {
    	$cnBeforeStatus = 'Created';
	}

    if ($status && $cnBeforeStatus) {
        CreditNotes4You_ProductsUpdate_Helper::updateInventoryProductsByStatus($entityId, $status);
    }
}

/**
 * @param $entity
 *
 * @throws Exception
 */
function handleInventoryProductRelCreditNotes($entity) {
    require_once("include/utils/InventoryUtils.php");

    $moduleName = $entity->getModuleName();
    if ('CreditNotes4You' === $moduleName) {
        global $cnBeforeStatus;

        $statusColumnName = CreditNotes4You::$statusFieldName;

        $status = $entity->get($statusColumnName);

        if ($statusColumnName) {

            $statusChanged = ($cnBeforeStatus !== $status);

			if ($statusChanged &&
                in_array($status, ['Refunded',])) {
                updateInventoryProductRelCreditNotes($entity);
            } elseif ($statusChanged &&
                in_array($cnBeforeStatus, ['Refunded']) &&
                in_array($status, ['Created', 'Cancelled'])) {
                updateInventoryProductRelCreditNotes($entity);
            }
        }
    }
}

