/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

Inventory_Edit_Js("CreditNotes4You_Edit_Js", {}, {

        accountRefrenceField: false,

        initializeVariables: function () {
            this._super();
            var form = this.getForm();
            this.accountReferenceField = form.find('[name="account_id"]');
        },

        /**
         * Function which will register event for Reference Fields Selection
         */
        registerReferenceSelectionEvent: function (container) {
            this._super(container);
            var self = this;

            this.accountReferenceField.on(Vtiger_Edit_Js.referenceSelectionEvent, function (e, data) {
                self.referenceSelectionEventHandler(data, container);
            });
        },

        /**
         * Function to get popup params
         */
        getPopUpParams: function (container) {
            let params = this._super(container),
                sourceFieldElement = jQuery('input[class="sourceField"]', container);

            if (!sourceFieldElement.length) {
                sourceFieldElement = jQuery('input.sourceField', container);
            }

            if ('contact_id' === sourceFieldElement.attr('name')) {
                let form = this.getForm(),
                    parentIdElement = form.find('[name="account_id"]');

                if (parentIdElement.length && parentIdElement.val().length && 0 < parentIdElement.val()) {
                    params['related_parent_id'] = parentIdElement.val();
                    params['related_parent_module'] = parentIdElement.closest('td').find('[name="popupReferenceModule"]').val();
                }
            }

            return params;
        },

        /**
         * Function to search module names
         */
        searchModuleNames: function (params) {
            var aDeferred = jQuery.Deferred();

            if (typeof params.module == 'undefined') {
                params.module = app.getModuleName();
            }
            if (typeof params.action == 'undefined') {
                params.action = 'BasicAjax';
            }

            if (typeof params.base_record == 'undefined') {
                var record = jQuery('[name="record"]');
                var recordId = app.getRecordId();
                if (record.length) {
                    params.base_record = record.val();
                } else if (recordId) {
                    params.base_record = recordId;
                } else if (app.view() == 'List') {
                    var editRecordId = jQuery('#listview-table').find('tr.listViewEntries.edited').data('id');
                    if (editRecordId) {
                        params.base_record = editRecordId;
                    }
                }
            }

            if (params.search_module == 'Contacts') {
                var form = this.getForm();
                if (this.accountReferenceField.length > 0 && this.accountReferenceField.val().length > 0) {
                    var closestContainer = this.accountReferenceField.closest('td');
                    params.parent_id = this.accountReferenceField.val();
                    params.parent_module = closestContainer.find('[name="popupReferenceModule"]').val();
                }
            }

            // Added for overlay edit as the module is different
            if (params.search_module == 'Products' || params.search_module == 'Services') {
                params.module = 'CreditNotes4You';
            }

            app.request.get({'data': params}).then(
                function (error, data) {
                    if (error == null) {
                        aDeferred.resolve(data);
                    }
                },
                function (error) {
                    aDeferred.reject();
                }
            )
            return aDeferred.promise();
        },

        registerBasicEvents: function (container) {
            this._super(container);
            this.registerForTogglingBillingandShippingAddress();
            this.registerEventForCopyAddress();
        },

        calculateGroupTax : function() {
            var numberOfDecimal = parseInt(jQuery('.numberOfCurrencyDecimal').val());
            var netTotal = this.getNetTotal();
            var finalDiscountValue = this.getFinalDiscountTotal();
            var amount = netTotal - finalDiscountValue;
            amount = parseFloat(amount).toFixed(numberOfDecimal);
            var groupTaxContainer = jQuery('#group_tax_div');
            var groupTaxTotal = 0;
            groupTaxContainer.find('.groupTaxPercentage').each(function(index,domElement){
                var groupTaxPercentageElement = jQuery(domElement);
                var groupTaxRow = groupTaxPercentageElement.closest('tr');
                if(isNaN(groupTaxPercentageElement.val())){
                    var groupTaxValue = "0.00";
                } else {
                    var groupTaxValue = (amount * groupTaxPercentageElement.val())/100;
                }
                groupTaxValue = parseFloat(groupTaxValue).toFixed(numberOfDecimal);
                groupTaxRow.find('.groupTaxTotal').val(groupTaxValue);
                groupTaxTotal += parseFloat(groupTaxValue);
            });
            this.setGroupTaxTotal(groupTaxTotal);
		},
        calculateTaxForLineItem : function(lineItemRow) {
            let self = this,
                totalAfterDiscount = this.getTotalAfterDiscount(lineItemRow),
                taxPercentages = jQuery('.taxPercentage',lineItemRow),
                taxTotal = 0;

            jQuery.each(taxPercentages,function(index,domElement){
                let taxPercentage = jQuery(domElement),
                    individualTaxRow = taxPercentage.closest('tr'),
                    individualTaxPercentage = taxPercentage.val(),
                    individualTaxTotal = 0;

                if(individualTaxPercentage == ''){
                    individualTaxPercentage = '0';
                }

                if(isNaN(individualTaxPercentage)){
                    individualTaxTotal = '0';
                } else {
                    individualTaxPercentage = parseFloat(individualTaxPercentage);
                    individualTaxTotal = Math.abs(individualTaxPercentage * totalAfterDiscount)/100;

                    if (totalAfterDiscount < 0) {
                        individualTaxTotal *= -1;
                    }

                    individualTaxTotal = individualTaxTotal.toFixed(self.numOfCurrencyDecimals);
                }

                individualTaxRow.find('.taxTotal').val(individualTaxTotal);
            });

            //Calculation compound taxes
            taxTotal = 0;

            jQuery.each(taxPercentages, function (index, domElement) {
                let taxElement = jQuery(domElement),
                    taxRow = taxElement.closest('tr'),
                    total = jQuery('.taxTotal', taxRow).val(),
                    compoundOn = taxElement.data('compoundOn');

                if (compoundOn) {
                    let amount = parseFloat(totalAfterDiscount);

                    jQuery.each(compoundOn, function (index, id) {
                        if (!isNaN(jQuery('.taxTotal' + id, lineItemRow).val())) {
                            amount = parseFloat(amount) + parseFloat(jQuery('.taxTotal' + id, lineItemRow).val());
                        }
                    });

                    if (isNaN(taxElement.val())) {
                        total = 0;
                    } else {
                        total = Math.abs(amount * taxElement.val()) / 100;
                    }

                    taxRow.find('.taxTotal').val(total);
                }

                taxTotal += parseFloat(total);
            });

            taxTotal = parseFloat(taxTotal).toFixed(self.numOfCurrencyDecimals);
            this.setLineItemTaxTotal(lineItemRow, taxTotal);
        },
    });
