<?php

/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

abstract class ITS4YouWarehouses_ProductWHRelatedList_View extends Products_Detail_View
{
    /**
     * @param Vtiger_Request $request
     * @param bool $display
     * @return bool|void
     */
    public function preProcess(Vtiger_Request $request, $display = true)
    {
        global $currentModule;
        // force setting of Products as a module in order to keep user in DetailView of Products
        $request->set("module", "Products");
        $currentModule = "Products";

        parent::preProcess($request, $display);
    }

    /**
     * @param Vtiger_Request $request
     * @return |array
     */
    public function getHeaderScripts(Vtiger_Request $request)
    {
        $headerScriptInstances = parent::getHeaderScripts($request);

        //new JS need to be added for providing JS controller for new view see app.js function getPageController
        $jsFileNames = array(
            'modules.ITS4YouWarehouses.resources.ProductWHRelatedList',
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }

    /**
     * @param Vtiger_Request $request
     * @return Vtiger_Request
     * @throws Exception
     */
    public function updateSearchParams(Vtiger_Request $request)
    {
        $searchParams = is_array($request->get('search_params')) ? $request->get('search_params') : json_decode($request->get('search_params'));

        if ($request->has('warehouseid')) {
            $warehouseId = $request->get('warehouseid');
        } else {
            $warehouseName = '';

            foreach ($searchParams as $searchValues) {
                foreach ($searchValues as $searchData) {
                    if(in_array('warehouse_name', $searchData)) {
                        $warehouseName = $searchData[2];
                    }
                }
            }

            $adb = PearDatabase::getInstance();
            $warehouseId = $adb->query_result($adb->pquery('SELECT warehouseid FROM its4you_warehouses WHERE warehouse_name LIKE ?', [$warehouseName]), 'warehouseid');
        }

        if(isRecordExists($warehouseId)) {
            $warehouse = Vtiger_Record_Model::getInstanceById($warehouseId);

            if ($warehouse) {
                $searchParams[0][] = ['warehouse_name', 'c', $warehouse->get('warehouse_name'), 'string'];

                $request->set('search_params', json_encode($searchParams));
                $request->set('warehouseid', $warehouseId);
            }
        }

        return $request;
    }
    /**
     * @param Vtiger_Request $request
     */
    public function process(Vtiger_Request $request)
    {
        $moduleName = 'ITS4YouWarehouses';       // cannot use value from $request since it's forced to be Products
        $request = $this->updateSearchParams($request);

        $requestedPage = $request->get('page');
        if (empty($requestedPage)) {
            $requestedPage = 1;
        }

        $pagingModel = new Vtiger_Paging_Model();
        $pagingModel->set('page', $requestedPage);

        $listViewModel = $this->getListViewModel($request);

        $viewer = $this->getViewer($request);

        $orderBy = $request->get('orderby');
        $sortOrder = $request->get('sortorder');
        if ($sortOrder == "ASC") {
            $nextSortOrder = "DESC";
            $sortImage = "icon-chevron-down";
            $faSortImage = "fa-sort-desc";
        } else {
            $nextSortOrder = "ASC";
            $sortImage = "icon-chevron-up";
            $faSortImage = "fa-sort-asc";
        }
        if (!empty($orderBy)) {
            $listViewModel->set('orderby', $orderBy);
            $listViewModel->set('sortorder', $sortOrder);
        }

        $searchKey = $request->get('search_key');
        $searchValue = $request->get('search_value');
        $operator = $request->get('operator');
        if (!empty($operator)) {
            $listViewModel->set('operator', $operator);
            $viewer->assign('OPERATOR', $operator);
            $viewer->assign('ALPHABET_VALUE', $searchValue);
        }
        if (!empty($searchKey) && !empty($searchValue)) {
            $listViewModel->set('search_key', $searchKey);
            $listViewModel->set('search_value', $searchValue);
        }

        $searchParmams = $request->get('search_params');
        if (empty($searchParmams)) {
            $searchParmams = array();
        }

        $transformedSearchParams = ITS4YouWarehouses_Util_Helper::transferListSearchParamsToFilterCondition($searchParmams, $listViewModel->getHeaders());
        $listViewModel->set('search_params', $transformedSearchParams);

        //To make smarty to get the details easily accesible
        foreach ($searchParmams as $fieldListGroup) {
            foreach ($fieldListGroup as $fieldSearchInfo) {
                $fieldSearchInfo['searchValue'] = $fieldSearchInfo[2];
                $fieldSearchInfo['fieldName'] = $fieldName = $fieldSearchInfo[0];
                $searchParmams[$fieldName] = $fieldSearchInfo;
            }
        }

        $entries = $listViewModel->getEntries($pagingModel);
        $headers = $listViewModel->getHeaders();

        $noOfEntries = $pagingModel->get('_relatedlistcount');

        if (!$noOfEntries) {
            $noOfEntries = count($entries);
        }

        $viewer->assign('CURRENT_USER_MODEL', Users_Record_Model::getCurrentUserModel());
        $viewer->assign('MODULE', $moduleName);

        $viewer->assign('PAGING_MODEL', $pagingModel);
        $viewer->assign('PAGE_NUMBER', $requestedPage);

        $viewer->assign('ORDER_BY', $orderBy);
        $viewer->assign('SORT_ORDER', $sortOrder);
        $viewer->assign('NEXT_SORT_ORDER', $nextSortOrder);
        $viewer->assign('SORT_IMAGE', $sortImage);
        $viewer->assign('COLUMN_NAME', $orderBy);

        $viewer->assign('LISTVIEW_ENTRIES_COUNT', $noOfEntries);
        $viewer->assign('LISTVIEW_HEADERS', $headers);
        $viewer->assign('LISTVIEW_ENTRIES', $entries);

        if (PerformancePrefs::getBoolean('LISTVIEW_COMPUTE_PAGE_COUNT', false)) {
            $totalCount = $listViewModel->getListViewCount();
            $pageLimit = $pagingModel->getPageLimit();
            $pageCount = ceil((int)$totalCount / (int)$pageLimit);

            if ($pageCount == 0) {
                $pageCount = 1;
            }

            $viewer->assign('PAGE_COUNT', $pageCount);
            $viewer->assign('LISTVIEW_COUNT', $totalCount);
            $viewer->assign('TOTAL_ENTRIES', $totalCount);
            $viewer->assign('PERFORMANCE', true);
        }

        $viewer->assign('SEARCH_DETAILS', $searchParmams);
        $viewer->assign('PRODUCTID', $request->get("record"));

        $viewer->assign('VIEWMODEL', array(
            "view" => $request->get("view"),
            "title" => $this->getTitle($request)
        ));

        $viewer->assign('PAGING', $pagingModel);
        $viewer->assign('FASORT_IMAGE',$faSortImage);
        $viewer->assign('USER_MODEL', Users_Record_Model::getCurrentUserModel());
        $viewer->assign('RELATED_HEADERS', $headers);
        $viewer->assign('RELATED_RECORDS' , $entries);
        $viewer->assign('RELATED_MODULE', Vtiger_Module_Model::getInstance('ITS4YouWarehouses'));
        $viewer->assign('RELATED_ENTIRES_COUNT', $noOfEntries);

        $fieldsInfo = array();

        foreach ($headers as $fieldName => $fieldModel) {
            $fieldsInfo[$fieldName] = $fieldModel->getFieldInfo();
        }

        $viewer->assign('RELATED_FIELDS_INFO', json_encode($fieldsInfo));
        $relatedModuleName = $request->get('relatedModule');
        $parentId = $request->get('record');
        $whereCondition = array();
        $requestedPage = $request->get('page');

        if(empty($requestedPage)) {
            $requestedPage = 1;
        }

        $pagingModel = new Vtiger_Paging_Model();
        $pagingModel->set('page',$requestedPage);
        $parentRecordModel = Vtiger_Record_Model::getInstanceById($parentId);

        if(!empty($whereCondition))
            $listViewModel->set('whereCondition', $whereCondition);

        $listViewModel->tab_label = $request->get('tab_label');
        $viewer->assign('IS_CREATE_PERMITTED', isPermitted($relatedModuleName, 'CreateView'));
        $viewer->assign('PARENT_RECORD', $parentRecordModel);
        $viewer->assign('RELATED_LIST_LINKS', []);
        $viewer->assign('SELECTED_MENU_CATEGORY', 'MARKETING');
        $viewer->assign('IS_EDITABLE', false);
        $viewer->assign('IS_DELETABLE', false);
        $viewer->assign('VIEW', $request->get('view'));
        $viewer->assign('PARENT_ID', $parentId);
        $viewer->assign('TAB_LABEL', $request->get('tab_label'));

        $this->adjustViewer($request, $viewer);

        $viewer->view('ProductWHRelatedList.tpl', $moduleName);
    }

    /**
     * @param Vtiger_Request $request
     * @return mixed
     */
    abstract public function getListViewModel(Vtiger_Request $request);

    /**
     * @param Vtiger_Request $request
     * @return mixed
     */
    abstract protected function getTitle(Vtiger_Request $request);

    /**
     * When overriding this method always call parent implementation too
     * @param Vtiger_Request $request
     * @param Vtiger_Viewer $viewer
     */
    protected function adjustViewer(Vtiger_Request $request, Vtiger_Viewer $viewer)
    {
        $viewer->assign("ADDITIONAL_TPL", $this->getAdditionalTemplateName());
    }

    /**
     * @return string
     */
    protected function getAdditionalTemplateName()
    {
        return "false";
    }
}
