<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_ProductInWarehousesBlock_View extends ITS4YouWarehouses_BasicDetail_View
{
    /**
     * called when the request is recieved.
     * if viewtype : detail then show location
     * @param Vtiger_Request $request
     */
    public function process(Vtiger_Request $request)
    {
        $mode = $request->get("mode");
        switch ($mode) {
            default:
                $this->showProductInWarehousesBlock($request);
        }
    }

    /**
     * display the template.
     * @param Vtiger_Request $request
     */
    private function showProductInWarehousesBlock(Vtiger_Request $request)
    {
        $movBlock = new ITS4YouWarehouses_ProductInWarehousesBlock_Helper($request->get("record"));
        $viewModel = $movBlock->getSideWidgetViewModel();
        $viewer = $this->getViewer($request);
        // record and source_module values to be passed to populate the values in the template,
        // required to get the respective records address based on the module type.
        $viewer->assign('RECORD', $request->get('record'));
        $viewer->assign('SOURCE_MODULE', $request->get('source_module'));
        $viewer->assign('MODULE_NAME', $request->getModule());
        $viewer->assign('MODULE', 'ITS4YouWarehouses');
        $viewer->assign('VIEW', 'ProductInWarehousesBlockActionHandler');
        $viewer->assign('VIEWMODEL', $viewModel);
        $viewer->assign('LANGUAGE_STRINGS', $this->getJSLanguageStrings($request));

        $viewer->view('ProductInWarehousesBlock.tpl', $request->getModule());
    }

    public function getJSLanguageStrings(Vtiger_Request $request)
    {
        $language = Vtiger_Language_Handler::getLanguage();
        $moduleStrings = Vtiger_Language_Handler::getModuleStringsFromFile($language, $request->getModule(false));
        return $moduleStrings["jsLanguageStrings"];
    }

    /**
     * @throws AppException
     */
    public function checkPermission(Vtiger_Request $request)
    {
        if (!$this->getSourceRecordPermissions($request)) {
            throw new AppException('LBL_PERMISSION_DENIED');
        }

        return true;
    }
}
