<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_ProductInWarehouses_View extends ITS4YouWarehouses_ProductWHRelatedList_View
{
    /**
     * @param Vtiger_Request $request
     * @return bool
     * @throws AppException
     */
    public function checkPermission(Vtiger_Request $request)
    {
        $moduleName = $request->getModule();
        $recordId = $request->get('record');
        $recordPermission = Users_Privileges_Model::isPermitted($moduleName, 'DetailView', $recordId);

        if (!$recordPermission) {
            throw new AppException('LBL_PERMISSION_DENIED');
        }

        return true;
    }

    public function getListViewModel(Vtiger_Request $request)
    {
        $listViewModel = new ITS4YouWarehouses_ProductInWarehousesListView_Model();
        $listViewModel->setProductId($request->get("record"));
        return $listViewModel;
    }

    protected function getTitle(Vtiger_Request $request)
    {
        return vtranslate('LBL_PRODUCT_IN_WAREHOUSES', 'ITS4YouWarehouses');
    }

}
