<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of PopupAjax
 *
 * @author zavad
 */
class ITS4YouWarehouses_PopupAjax_View extends ITS4YouWarehouses_Popup_View
{

    public function __construct()
    {
        parent::__construct();
        $this->exposeMethod('getListViewCount');
        $this->exposeMethod('getRecordsCount');
        $this->exposeMethod('getPageCount');
    }

    /**
     * @param Vtiger_Request $request
     * @param bool $display
     * @return bool
     */
    public function preProcess(Vtiger_Request $request, $display = true)
    {
        return true;
    }

    /**
     * @param Vtiger_Request $request
     * @return bool
     */
    public function postProcess(Vtiger_Request $request)
    {
        return true;
    }

    /**
     * @param Vtiger_Request $request
     * @throws Exception
     */
    public function process(Vtiger_Request $request)
    {
        $mode = $request->get('mode');
        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
            return;
        }
        $viewer = $this->getViewer($request);
        $moduleName = $request->getModule();

        $this->initializeListViewContents($request, $viewer);

        $viewer->view('PopupContents.tpl', $moduleName);
    }

}
