<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Popup
 *
 * @author zavad
 */
class ITS4YouWarehouses_Popup_View extends Vtiger_Popup_View
{

    /**
     * Overriden method which distinguish whether the Popup is called from DN distribution block
     * or from standard field for warehouse
     * @param Vtiger_Request $request
     * @param Vtiger_Viewer $viewer
     * @throws Exception
     */
    public function initializeListViewContents(Vtiger_Request $request, Vtiger_Viewer $viewer)
    {
        if ($request->get('related_parent_module') == "Products" && $request->get("related_parent_id", 0) > 0) {
            $this->initializeListViewContentsForDistributionBlock($request, $viewer);
        } else {
            parent::initializeListViewContents($request, $viewer);
        }
    }

    /**
     * @param Vtiger_Request $request
     * @param Vtiger_Viewer $viewer
     * @throws Exception
     */
    protected function initializeListViewContentsForDistributionBlock(Vtiger_Request $request, Vtiger_Viewer $viewer)
    {
        $moduleName = $this->getModule($request);
        $cvId = $request->get('cvid');
        $pageNumber = $request->get('page');
        $orderBy = $request->get('orderby');
        $sortOrder = $request->get('sortorder');
        $sourceModule = $request->get('src_module');
        $sourceField = $request->get('src_field');
        $sourceRecord = $request->get('src_record');
        $searchKey = $request->get('search_key');
        $searchValue = $request->get('search_value');
        $currencyId = $request->get('currency_id');
        $relatedParentModule = $request->get('related_parent_module');
        $relatedParentId = $request->get('related_parent_id');
        //get productId from request
        if ($relatedParentModule == "Products") {
            $productId = $relatedParentId;
        }

        //To handle special operation when selecting record from Popup
        $getUrl = $request->get('get_url');

        //Check whether the request is in multi select mode
        $multiSelectMode = $request->get('multi_select');
        if (empty($multiSelectMode)) {
            $multiSelectMode = false;
        }

        if (empty($cvId)) {
            $cvId = '0';
        }
        if (empty($pageNumber)) {
            $pageNumber = '1';
        }

        $pagingModel = new Vtiger_Paging_Model();
        $pagingModel->set('page', $pageNumber);

        $moduleModel = Vtiger_Module_Model::getInstance($moduleName);

        if (isRecordExists($relatedParentId)) {
            $recordModel = Vtiger_Record_Model::getInstanceById($relatedParentId);
            $recordStructureInstance = Vtiger_RecordStructure_Model::getInstanceFromRecordModel($recordModel, Vtiger_RecordStructure_Model::RECORD_STRUCTURE_MODE_SUMMARY);
        } else {
            $recordStructureInstance = Vtiger_RecordStructure_Model::getInstanceForModule($moduleModel, Vtiger_RecordStructure_Model::RECORD_STRUCTURE_MODE_SUMMARY);
        }
        //call custom method for retrieving listViewModel
        $listViewModel = $this->getInstanceForPopup($moduleName);
        /* @var $listViewModel ITS4YouWarehouses_WarehouseWithProductListView_Model */

        $listViewModel->extendPopupFields(array("qtyinstock" => "qtyinstock"));

        if (!empty($orderBy)) {
            $listViewModel->set('orderby', $orderBy);
            $listViewModel->set('sortorder', $sortOrder);
        }
        if (!empty($sourceModule)) {
            $listViewModel->set('src_module', $sourceModule);
            $listViewModel->set('src_field', $sourceField);
            $listViewModel->set('src_record', $sourceRecord);
        }
        if ((!empty($searchKey)) && (!empty($searchValue))) {
            $listViewModel->set('search_key', $searchKey);
            $listViewModel->set('search_value', $searchValue);
        }
        //add productId to listViewModel
        if (!empty($productId)) {
            $listViewModel->set('productId', $productId);
        }

        $this->listViewHeaders = $listViewModel->getListViewHeaders();
        $this->listViewEntries = $listViewModel->getListViewEntries($pagingModel);


        $noOfEntries = count($this->listViewEntries);

        if (empty($sortOrder)) {
            $sortOrder = "ASC";
        }
        if ($sortOrder == "ASC") {
            $nextSortOrder = "DESC";
            $sortImage = "icon-chevron-down";
            $faSortImage = "fa-sort-desc";
        } else {
            $nextSortOrder = "ASC";
            $sortImage = "icon-chevron-up";
            $faSortImage = "fa-sort-asc";
        }

        $viewer->assign('MODULE', $moduleName);
        $viewer->assign('RELATED_MODULE', $moduleName);
        $viewer->assign('MODULE_NAME', $moduleName);

        $viewer->assign('SOURCE_MODULE', $sourceModule);
        $viewer->assign('SOURCE_FIELD', $sourceField);
        $viewer->assign('SOURCE_RECORD', $sourceRecord);
        $viewer->assign('RELATED_PARENT_MODULE', $relatedParentModule);
        $viewer->assign('RELATED_PARENT_ID', $relatedParentId);

        $viewer->assign('SEARCH_KEY', $searchKey);
        $viewer->assign('SEARCH_VALUE', $searchValue);

        $viewer->assign('ORDER_BY', $orderBy);
        $viewer->assign('SORT_ORDER', $sortOrder);
        $viewer->assign('NEXT_SORT_ORDER', $nextSortOrder);
        $viewer->assign('SORT_IMAGE', $sortImage);
        $viewer->assign('FASORT_IMAGE', $faSortImage);
        $viewer->assign('GETURL', $getUrl);
        $viewer->assign('CURRENCY_ID', $currencyId);

        $viewer->assign('RECORD_STRUCTURE_MODEL', $recordStructureInstance);
        $viewer->assign('RECORD_STRUCTURE', $recordStructureInstance->getStructure());

        $viewer->assign('PAGING_MODEL', $pagingModel);
        $viewer->assign('PAGE_NUMBER', $pageNumber);

        $viewer->assign('LISTVIEW_ENTRIES_COUNT', $noOfEntries);
        $viewer->assign('LISTVIEW_HEADERS', $this->listViewHeaders);
        $viewer->assign('LISTVIEW_ENTRIES', $this->listViewEntries);

        if (PerformancePrefs::getBoolean('LISTVIEW_COMPUTE_PAGE_COUNT', false)) {
            if (!$this->listViewCount) {
                $this->listViewCount = $listViewModel->getListViewCount();
            }
            $totalCount = $this->listViewCount;
            $pageLimit = $pagingModel->getPageLimit();
            $pageCount = ceil((int)$totalCount / (int)$pageLimit);

            if ($pageCount == 0) {
                $pageCount = 1;
            }
            $viewer->assign('PAGE_COUNT', $pageCount);
            $viewer->assign('LISTVIEW_COUNT', $totalCount);
        }

        $viewer->assign('MULTI_SELECT', $multiSelectMode);
        $viewer->assign('CURRENT_USER_MODEL', Users_Record_Model::getCurrentUserModel());
    }

    /**
     * Function to get the Instance of Vtiger ListView model for a given module and custom view
     * @return Vtiger_ListView_Model instance
     * @throws Exception
     */
    protected function getInstanceForPopup()
    {
        $db = PearDatabase::getInstance();

        $currentUser = vglobal('current_user');

        $instance = new ITS4YouWarehouses_WarehouseWithProductListView_Model();
        $moduleModel = Vtiger_Module_Model::getInstance("ITS4YouWarehouses");

        $queryGenerator = new EnhancedQueryGenerator($moduleModel->get('name'), $currentUser);

        $listFields = $moduleModel->getPopupViewFieldsList();

        $listFields[] = 'id';
        $queryGenerator->setFields($listFields);

        $controller = new ListViewController($db, $currentUser, $queryGenerator);

        $instance->set('module', $moduleModel)->set('query_generator', $queryGenerator)->set('listview_controller', $controller);

        return $instance;
    }

    /**
     * Function to get listView count
     * @param Vtiger_Request $request
     * @return string
     * @throws Exception
     */
    public function getListViewCount(Vtiger_Request $request)
    {
        $moduleName = $this->getModule($request);
        $sourceModule = $request->get('src_module');
        $sourceField = $request->get('src_field');
        $sourceRecord = $request->get('src_record');
        $orderBy = $request->get('orderby');
        $sortOrder = $request->get('sortorder');
        $currencyId = $request->get('currency_id');

        $searchKey = $request->get('search_key');
        $searchValue = $request->get('search_value');

        $relatedParentModule = $request->get('related_parent_module');
        $relatedParentId = $request->get('related_parent_id');

        if ($relatedParentModule == "Products" && $relatedParentId > 0) {
            $listViewModel = $this->getInstanceForPopup($moduleName);
            $listViewModel->set('productId', $relatedParentId);
        } else {
            if (!empty($relatedParentModule) && !empty($relatedParentId)) {
                $parentRecordModel = Vtiger_Record_Model::getInstanceById($relatedParentId, $relatedParentModule);
                $listViewModel = Vtiger_RelationListView_Model::getInstance($parentRecordModel, $moduleName, $label);
            } else {
                $listViewModel = Vtiger_ListView_Model::getInstanceForPopup($moduleName);
            }
        }

        if (!empty($sourceModule)) {
            $listViewModel->set('src_module', $sourceModule);
            $listViewModel->set('src_field', $sourceField);
            $listViewModel->set('src_record', $sourceRecord);
            $listViewModel->set('currency_id', $currencyId);
        }

        if (!empty($orderBy)) {
            $listViewModel->set('orderby', $orderBy);
            $listViewModel->set('sortorder', $sortOrder);
        }
        if ((!empty($searchKey)) && (!empty($searchValue))) {
            $listViewModel->set('search_key', $searchKey);
            $listViewModel->set('search_value', $searchValue);
        }

        if ($relatedParentModule == "Products" && $relatedParentId > 0) {
            $count = $listViewModel->getListViewCount();
        } else {
            if (!empty($relatedParentModule) && !empty($relatedParentId)) {
                $count = $listViewModel->getRelatedEntriesCount();
            } else {
                $count = $listViewModel->getListViewCount();
            }
        }

        return $count;
    }

}
