/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */
/** @var ITS4YouProductBlocksUtils_Js */

jQuery.Class("ITS4YouProductBlocksUtils_Js", {
	registerEvents: function () {
		ITS4YouProductBlocksUtils_Js.registerProductMovementsEvents();
		ITS4YouProductBlocksUtils_Js.registerProductInWarehousesEvents();
	},
	registerProductMovementsEvents: function () {
		let url = 'index.php?module=ITS4YouWHDeliveryNotes&view=ProductMovements&record=' + jQuery('form#productMovementsBlockForm input[name="sourceRecord"]').val();
		jQuery('form#productMovementsBlockForm .actionShowOverview').off('click').on('click', function (e) {
			window.location.href = url;
		});
	},
	registerProductInWarehousesEvents: function () {
		let url = 'index.php?module=ITS4YouWHDeliveryNotes&view=ProductInWarehouses&record=' + jQuery('form#productInWarehousesBlockForm input[name="sourceRecord"]').val();
		jQuery('form#productInWarehousesBlockForm .actionShowOverview').off('click').on('click', function (e) {
			window.location.href = url;
		});
	},
	selectProductMovementsRelatedTabs: function () {
		let detailViewInstance = Vtiger_Detail_Js.getInstance();

		detailViewInstance.deSelectAllrelatedTabs();
		detailViewInstance.markTabAsSelected(detailViewInstance.getTabByLabel('ITS4YouReceiptcards'));
		detailViewInstance.markTabAsSelected(detailViewInstance.getTabByLabel('ITS4YouWHDeliveryNotes'));
	}
}, {});

jQuery(document).ready(function () {
	ITS4YouProductBlocksUtils_Js.registerEvents();
});