<?php
/*********************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_ProductsInWarehouseRecord_Model extends Vtiger_Record_Model
{
    /**
     * @return void
     * @throws Exception
     */
    public function getModule()
    {
        throw new Exception('Warehouses :: ProductsInWarehouse does not support module model reference.');
    }

    /**
     * @return string
     */
    public function getDetailViewUrl()
    {
        return 'index.php?module=Products&view=Detail&record=' . $this->get('crmid');
    }

    /**
     * @return string
     */
    public function getMovementsUrl()
    {
        $relationModel = Vtiger_Relation_Model::getInstance(Vtiger_Module_Model::getInstance('Products'), Vtiger_Module_Model::getInstance('ITS4YouWarehouses'), 'ProductMovements');
        $recordModel = Vtiger_Record_Model::getInstanceById($this->get('crmid'));

        return 'index.php?' . $relationModel->getListUrl($recordModel) . '&tab_label=' . $relationModel->get('label') . '&warehouseid=' . $this->get('warehouseid');
    }

    /**
     * @return string
     */
    public function getCreateRCUrl()
    {
        return 'index.php?module=ITS4YouReceiptcards&view=Edit&sourceModule=ITS4YouWarehouses&sourceRecord=' . $this->get('warehouseid') . '&productid=' . $this->get('crmid');
    }

    /**
     * @param string $fieldName
     * @param bool $recordId
     * @return string
     */
    public function getDisplayValue($fieldName, $recordId = false)
    {
        return $this->get($fieldName);
    }
}