<?php
/* * *******************************************************************************
 * The content of this file is subject to the MultiWarehouses4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_ProductInWarehousesListView_Model extends Vtiger_Base_Model
{

    protected $productId;
    protected $headerFields = array();

    public function __construct($values = array())
    {
        parent::__construct($values);

        $this->productId = false;
        $className = 'ITS4YouWarehouses_DummyListViewField_Model';
        $fieldModel = new $className("warehouse_no", "warehouse_no", "LBL_WAREHOUSE_NO", 2);
        $fieldModel->set("navigatable", true);
        $this->headerFields["warehouse_no"] = $fieldModel;
        $this->headerFields["warehouse_name"] = new $className(
            "warehouse_name",
            "warehouse_name",
            "LBL_WAREHOUSE_NAME",
            2
        );
        $this->headerFields["quantity"] = new $className("quantity", "quantity", "HEAD_QTY", 7);
    }

    public function setProductId($productId)
    {
        $this->productId = $productId;
    }

    public function getHeaders()
    {
        return $this->headerFields;
    }

    public function getEntries($pagingModel)
    {
        $db = PearDatabase::getInstance();

        $searchParams = $this->get('search_params');
        if (empty($searchParams)) {
            $searchParams = array();
        }
        list($searchQuery, $params) = $this->getSearchQuery($searchParams);
        $listQuery = $this->getQuery() . $searchQuery;

        $orderBy = $this->getForSql('orderby');
        $sortOrder = $this->getForSql('sortorder');

        $startIndex = $pagingModel->getStartIndex();
        $pageLimit = $pagingModel->getPageLimit();

        if (!empty($orderBy)) {
            $listQuery .= ' ORDER BY ' . $orderBy . ' ' . $sortOrder;
        } else {
            $listQuery .= ' ORDER BY warehouse_no';
        }
        $listQuery .= " LIMIT $startIndex," . ($pageLimit + 1);

        $listResult = $db->pquery($listQuery, $params);
        $listViewRecordModels = array();
        $listViewEntries = $this->getListViewRecords($listResult);

        $pagingModel->calculatePageRange($listViewEntries);

        if ($db->num_rows($listResult) > $pageLimit) {
            array_pop($listViewEntries);
            $pagingModel->set('nextPageExists', true);
        } else {
            $pagingModel->set('nextPageExists', false);
        }

        $index = 0;
        foreach ($listViewEntries as $recordId => $record) {
            $rawData = $db->query_result_rowdata($listResult, $index++);
            $record['id'] = $recordId;
            $listViewRecordModels[$recordId] = $this->getRecordFromArray($record, $rawData);
        }

        return $listViewRecordModels;
    }

    private function getSearchQuery($searchParams)
    {
        $searchQuery = "";
        $params = array();

        if ($this->productId !== false) {
            $params = array($this->productId);
        }
        if (isset($searchParams[0]["columns"])) {
            $subSearchParams = $searchParams[0]["columns"];
            foreach ($subSearchParams as $searchParamsArr) {
                $condition = isset($searchParamsArr["column_condition"]) ? $searchParamsArr["column_condition"] : "";
                switch ($searchParamsArr["columnname"]) {
                    case "quantity":
                        $searchQuery .= $searchParamsArr["columnname"] . " = ? " . $condition . " ";
                        array_push($params, $searchParamsArr["value"]);
                        break;

                    default:
                        $searchQuery .= $searchParamsArr["columnname"] . " LIKE ? " . $condition . " ";
                        array_push($params, "%" . $searchParamsArr["value"] . "%");
                        break;
                }
            }
        }
        if ($searchQuery != "") {
            $searchQuery = " AND " . $searchQuery;
        }

        return array($searchQuery, $params);
    }

    /**
     * @return string
     */
    private function getQuery()
    {
        $query = 'SELECT    its4you_warehouses.warehouse_no,
                            its4you_warehouses.warehouse_name,
                            its4you_warehouses_productrel.quantity,
                            vtiger_crmentity.crmid
                    FROM    its4you_warehouses
                    INNER JOIN its4you_warehouses_productrel
                        ON its4you_warehouses.warehouseid = its4you_warehouses_productrel.warehouseid
                    INNER JOIN vtiger_crmentity
                        ON its4you_warehouses.warehouseid = vtiger_crmentity.crmid
                    LEFT JOIN vtiger_users 
                        ON vtiger_users.id = vtiger_crmentity.smownerid
                    LEFT JOIN vtiger_groups 
                        ON vtiger_groups.groupid = vtiger_crmentity.smownerid
                    WHERE vtiger_crmentity.deleted = 0 ';

        if ($this->productId) {
            $query .= ' AND its4you_warehouses_productrel.productid=? ';
        }

        $query .= ' AND ' . $this->getListViewSecurityParameter('ITS4YouWarehouses');

        return $query;
    }

    private function getListViewSecurityParameter($module)
    {
        global $current_user;

        $profileGlobalPermission = $current_user_groups = $defaultOrgSharingPermission = [];
        $is_admin = false;
        $current_user_parent_role_seq = null;

        require 'user_privileges/user_privileges_' . $current_user->id . '.php';
        require 'user_privileges/sharing_privileges_' . $current_user->id . '.php';

        $tabid = getTabid($module);
        $sec_query = " (vtiger_crmentity.setype = '" . $module . "'";

        if ($is_admin == false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 && $defaultOrgSharingPermission[$tabid] == 3) {
            $sec_query .= " AND 
                        (vtiger_crmentity.smownerid IN (" . $current_user->id . " )
                            OR vtiger_crmentity.smownerid IN
                             (
                                 SELECT vtiger_user2role.userid FROM vtiger_user2role
                                 INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid
                                 INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid
                                 WHERE vtiger_role.parentrole LIKE '" . $current_user_parent_role_seq . "::%'
                             )
                             OR vtiger_crmentity.smownerid IN
                             (
                                 SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per
                                 WHERE userid=" . $current_user->id . " AND tabid=" . $tabid . "
                             )
                             OR
                             (";

            // Build the query based on the group association of current user.
            if (sizeof($current_user_groups) > 0) {
                $sec_query .= " vtiger_groups.groupid IN (" . implode(",", $current_user_groups) . ") OR ";
            }

            $sec_query .= " vtiger_groups.groupid IN
						(
                            SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid
                            FROM vtiger_tmp_read_group_sharing_per
                            WHERE userid=" . $current_user->id . " and tabid=" . $tabid . "
						)";
            $sec_query .= ")
                    )";
        }
        $sec_query .= ")";

        return $sec_query;
    }

    private function getListViewRecords($_dbResult)
    {
        $db = PearDatabase::getInstance();
        $listViewEntries = array();
        while ($row = $db->fetchByAssoc($_dbResult)) {
            foreach ($row as $key => $val) {
                switch ($key) {
                    case "quantity":
                        $tmpVal = ITS4YouWarehouses_Base_ActionBlock::formatNumberForDetailView($val);
                        break;

                    default:
                        $tmpVal = $val;
                }
                $listViewEntries[$row["crmid"]][$key] = $tmpVal;
            }
        }

        return $listViewEntries;
    }

    private function getRecordFromArray($valueArray, $rawData)
    {
        $recordInstance = new ITS4YouWarehouses_ProductInWarehousesRecord_Model();

        return $recordInstance->setData($valueArray)->setRawData($rawData);
    }

    /**
     * @return mixed
     * @throws Exception
     */
    public function getRelatedEntriesCount()
    {
        return $this->getListViewCount();
    }

    /**
     * Function to get the list view entries
     * @param Vtiger_Paging_Model $pagingModel
     * @return <Array> - Associative array of record id mapped to Vtiger_Record_Model instance.
     */
    public function getListViewCount()
    {
        $db = PearDatabase::getInstance();

        $searchParams = $this->get('search_params');
        if (empty($searchParams)) {
            $searchParams = array();
        }

        list($searchQuery, $params) = $this->getSearchQuery($searchParams);
        $listQuery = $this->getQuery() . $searchQuery;

        $position = stripos($listQuery, 'FROM');
        if ($position) {
            $explode = explode('FROM', $listQuery);
            unset($explode[0]);

            $listQuery = 'SELECT count(*) AS count FROM ' . implode('FROM', $explode);
        }

        $result = $db->pquery($listQuery, $params);

        return $db->query_result($result, 0, 'count');
    }
}

