<?php

/* * *******************************************************************************
 * The content of this file is subject to the DeliveryNotes4You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouWarehouses_InventoryRecord_Model extends Inventory_Record_Model
{

    /**
     * @return array|string
     * @throws Exception
     */
    public function getCurrencyInfo()
    {
        return ITS4YouWarehouses_InventoryUtils_Helper::getParentInventoryCurrencyInfo($this->getEntity());
    }

    /**
     * @return array|mixed|Value
     * @throws Exception
     */
    public function getProductTaxes()
    {
        $taxDetails = $this->get('taxDetails');

        if ($taxDetails) {
            return $taxDetails;
        }

        $record = $this->getId();

        if ($record) {
            $relatedProducts = ITS4YouWarehouses_InventoryUtils_Helper::getAssociatedProducts($this->getEntity());
            $taxDetails = $relatedProducts[1]['final_details']['taxes'];
        } else {
            $taxDetails = getAllTaxes('available', '', $this->getEntity()->mode, $this->getId());
        }

        $this->set('taxDetails', $taxDetails);
        return $taxDetails;
    }

    /**
     * @return array|mixed|Value
     * @throws Exception
     */
    public function getShippingTaxes()
    {
        $shippingTaxDetails = $this->get('shippingTaxDetails');

        if ($shippingTaxDetails) {
            return $shippingTaxDetails;
        }
        $record = $this->getId();

        if ($record) {
            $relatedProducts = ITS4YouWarehouses_InventoryUtils_Helper::getAssociatedProducts($this->getEntity());
            $shippingTaxDetails = $relatedProducts[1]['final_details']['sh_taxes'];
        } else {
            $shippingTaxDetails = getAllTaxes('available', 'sh', 'edit', $this->getId());
        }
        $this->set('shippingTaxDetails', $shippingTaxDetails);
        return $shippingTaxDetails;
    }

    /**
     * @return array
     * @throws Exception
     */
    public function getProducts()
    {
        $numOfCurrencyDecimalPlaces = getCurrencyDecimalPlaces();
        $relatedProducts = ITS4YouWarehouses_InventoryUtils_Helper::getAssociatedProducts($this->getEntity());
        $productsCount = count($relatedProducts);

        //Updating Pre tax total
        $preTaxTotal = (float)$relatedProducts[1]['final_details']['hdnSubTotal'] + (float)$relatedProducts[1]['final_details']['shipping_handling_charge'] - (float)$relatedProducts[1]['final_details']['discountTotal_final'];

        $relatedProducts[1]['final_details']['preTaxTotal'] = number_format($preTaxTotal, $numOfCurrencyDecimalPlaces, '.', '');

        //Updating Total After Discount
        $totalAfterDiscount = (float)$relatedProducts[1]['final_details']['hdnSubTotal'] - (float)$relatedProducts[1]['final_details']['discountTotal_final'];

        $relatedProducts[1]['final_details']['totalAfterDiscount'] = number_format($totalAfterDiscount, $numOfCurrencyDecimalPlaces, '.', '');

        //Updating Tax details
        $taxtype = $relatedProducts[1]['final_details']['taxtype'];
        $productIdsList = array();

        for ($i = 1; $i <= $productsCount; $i++) {
            $product = $relatedProducts[$i];
            $productId = $product['hdnProductId' . $i];
            $totalAfterDiscount = $product['totalAfterDiscount' . $i];

            if ($taxtype == 'individual') {
                $taxDetails = getTaxDetailsForProduct($productId, 'all');
                $taxCount = count($taxDetails);
                $taxTotal = '0.00';

                for ($j = 0; $j < $taxCount; $j++) {
                    $taxValue = $product['taxes'][$j]['percentage'];

                    $taxAmount = $totalAfterDiscount * $taxValue / 100;
                    $taxTotal = (int)$taxTotal + (int)$taxAmount;

                    $product['taxes'][$j]['amount'] = $taxAmount;
                    $relatedProducts[$i]['taxes'][$j]['amount'] = $taxAmount;
                    $relatedProducts[$i]['taxTotal' . $i] = $taxTotal;

                    $productTaxes = array();

                    if ($product['taxes']) {
                        foreach ($product['taxes'] as $key => $taxInfo) {
                            $taxInfo['key'] = $key;
                            $productTaxes[$taxInfo['taxid']] = $taxInfo;
                        }
                    }

                    $taxTotal = 0.00;

                    foreach ($productTaxes as $taxId => $taxInfo) {
                        $taxAmount = $taxInfo['amount'];
                        if ($taxInfo['compoundon']) {
                            $amount = $totalAfterDiscount;
                            foreach ($taxInfo['compoundon'] as $compTaxId) {
                                $amount = $amount + $productTaxes[$compTaxId]['amount'];
                            }
                            $taxAmount = $amount * $taxInfo['percentage'] / 100;
                        }
                        $taxTotal = $taxTotal + $taxAmount;

                        $relatedProducts[$i]['taxes'][$taxInfo['key']]['amount'] = $taxAmount;
                        $relatedProducts[$i]['taxTotal' . $i] = number_format($taxTotal, $numOfCurrencyDecimalPlaces, '.', '');
                    }
                }
                $netPrice = $totalAfterDiscount + $taxTotal;
                $relatedProducts[$i]['netPrice' . $i] = $netPrice;
            }

            if ($relatedProducts[$i]['entityType' . $i] == 'Products') {
                $productIdsList[] = $productId;
            }
        }

        //Updating Pre tax total
        $preTaxTotal = (float)$relatedProducts[1]['final_details']['hdnSubTotal']
            + (float)$relatedProducts[1]['final_details']['shipping_handling_charge']
            - (float)$relatedProducts[1]['final_details']['discountTotal_final'];

        $relatedProducts[1]['final_details']['preTaxTotal'] = number_format($preTaxTotal, $numOfCurrencyDecimalPlaces, '.', '');

        //Updating Total After Discount
        $totalAfterDiscount = (float)$relatedProducts[1]['final_details']['hdnSubTotal'] - (float)$relatedProducts[1]['final_details']['discountTotal_final'];

        $relatedProducts[1]['final_details']['totalAfterDiscount'] = number_format($totalAfterDiscount, $numOfCurrencyDecimalPlaces, '.', '');
        $relatedProducts[1]['final_details']['discount_amount_final'] = number_format((float)$relatedProducts[1]['final_details']['discount_amount_final'], $numOfCurrencyDecimalPlaces, '.', '');

        //charge value setting to related products array
        $selectedChargesAndItsTaxes = $this->getCharges();
        if (!$selectedChargesAndItsTaxes) {
            $selectedChargesAndItsTaxes = array();
        }
        $relatedProducts[1]['final_details']['chargesAndItsTaxes'] = $selectedChargesAndItsTaxes;

        $allChargeTaxes = array();
        foreach ($selectedChargesAndItsTaxes as $chargeId => $chargeInfo) {
            if (is_array($chargeInfo['taxes'])) {
                $allChargeTaxes = array_merge($allChargeTaxes, array_keys($chargeInfo['taxes']));
            } else {
                $selectedChargesAndItsTaxes[$chargeId]['taxes'] = array();
            }
        }

        $shippingTaxes = array();
        $allShippingTaxes = getAllTaxes('all', 'sh');
        foreach ($allShippingTaxes as $shTaxInfo) {
            $shippingTaxes[$shTaxInfo['taxid']] = $shTaxInfo;
        }

        $totalAmount = 0.00;
        foreach ($selectedChargesAndItsTaxes as $chargeId => $chargeInfo) {
            foreach ($chargeInfo['taxes'] as $taxId => $taxPercent) {
                $amount = $calculatedOn = $chargeInfo['value'];

                if ($shippingTaxes[$taxId]['method'] === 'Compound') {
                    $compoundTaxes = Zend_Json::decode(html_entity_decode($shippingTaxes[$taxId]['compoundon']));
                    if (is_array($compoundTaxes)) {
                        foreach ($compoundTaxes as $comTaxId) {
                            if ($shippingTaxes[$comTaxId]) {
                                $calculatedOn += ((float)$amount * (float)$chargeInfo['taxes'][$comTaxId]) / 100;
                            }
                        }
                    }
                }
                $totalAmount += ((float)$calculatedOn * (float)$taxPercent) / 100;
            }
        }
        $relatedProducts[1]['final_details']['shtax_totalamount'] = number_format($totalAmount, $numOfCurrencyDecimalPlaces, '.', '');

        //deduct tax values setting to related products
        $totalAfterDiscount = (float)$relatedProducts[1]['final_details']['totalAfterDiscount'];
        $deductedTaxesTotalAmount = 0.00;

        $deductTaxes = $this->getDeductTaxes();
        foreach ($deductTaxes as $taxId => $taxInfo) {
            $taxAmount = ($totalAfterDiscount * (float)$taxInfo['percentage']) / 100;
            $deductTaxes[$taxId]['amount'] = number_format($taxAmount, $numOfCurrencyDecimalPlaces, '.', '');
            if ($taxInfo['selected']) {
                $deductedTaxesTotalAmount = $deductedTaxesTotalAmount + $taxAmount;
            }
        }

        $relatedProducts[1]['final_details']['deductTaxes'] = $deductTaxes;
        $relatedProducts[1]['final_details']['deductTaxesTotalAmount'] = number_format($deductedTaxesTotalAmount, $numOfCurrencyDecimalPlaces, '.', '');

        if ($productIdsList) {
            $imageDetailsList = Products_Record_Model::getProductsImageDetails($productIdsList);

            for ($i = 1; $i <= $productsCount; $i++) {
                $product = $relatedProducts[$i];
                $productId = $product['hdnProductId' . $i];
                $imageDetails = $imageDetailsList[$productId];
                if ($imageDetails) {
                    $relatedProducts[$i]['productImage' . $i] = $imageDetails[0]['path'] . '_' . $imageDetails[0]['orgname'];
                }
            }
        }

        return $relatedProducts;
    }

}
